/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps, RichText, InnerBlocks } from '@wordpress/block-editor';

/**
 * The save function defines the way in which the different attributes should
 * be combined into the final markup, which is then serialized by the block
 * editor into `post_content`.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#save
 *
 * @return {Element} Element to render.
 */
export default function save({ attributes }) {
	const { title, borderEnabled, borderColor, borderWidth } = attributes;
	const style =
		borderEnabled
			? {
				border: `${borderWidth || 1}px solid ${borderColor || '#dddddd'}`,
				borderRadius: '4px',
			}
			: { border: 'none' };
	const blockProps = useBlockProps.save({
		className: 'my-expander',
		style,
	});

	return (
		<div {...blockProps}>
			<div className="my-expander-title">
				<RichText.Content tagName="span" value={title} />
			</div>

			<div className="my-expander-content">
				<InnerBlocks.Content />
			</div>
		</div>
	);
}
