<?php

namespace view\users\login;

use utils\Flush;
use utils\ReturnTo;

use function middleware\currentUser;

function index(): void
{
    $user = currentUser();

    if (!empty($user)) {
        Flush::push(Flush::ERROR, 'すでにログインしています');
        redirect(ReturnTo::pop() ?? '/campgrounds');
    }

    \view\layouts\index("\\view\\users\\login\\content", null);
}

function content(null $dummy): void
{
?>
    <div class="container">
        <div class="row">
            <div class="col-md-6 offset-md-3 col-xl-4 offset-xl-4">
                <div class="card shadow">
                    <img src="https://images.unsplash.com/photo-1571863533956-01c88e79957e?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=1267&q=80"
                        alt="" class="card-img-top" />
                    <div class="card-body">
                        <h5 class="card-title">ログイン</h5>
                        <form action="<?php echo BASE_CONTEXT_PATH; ?>login" method="POST" class="validated-form" novalidate>
                            <div class="mb-3">
                                <label class="form-label" for="username">ユーザー名</label>
                                <input class="form-control" type="text" name="username" id="username" autofocus required>
                                <div class="valid-feedback">
                                    OK!
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" for="password">パスワード</label>
                                <input class="form-control" type="password" name="password" id="password" required>
                                <div class="valid-feedback">
                                    OK!
                                </div>
                            </div>
                            <div class="d-grid">
                                <button class="btn btn-success">ログイン</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
}
