<?php

namespace views\partials;

use utils\Flush;

function flush(): void
{
    $msgs_with_type = Flush::pop();

    if (!is_iterable($msgs_with_type)) return;

    foreach ($msgs_with_type as $type => $msgs) {

        if (empty($msgs)) continue;
        // @phpstan-ignore booleanAnd.alwaysFalse, booleanNot.alwaysFalse
        if ($type === Flush::DEBUG && !DEBUG) continue;

        $color = $type === Flush::INFO ? 'alert-success' : 'alert-danger';
        echo "<div class='alert {$color} alert-dismissible fade show' role='alert'>";

        foreach (toStrArray($msgs) as $msg) {
            echo "<div>{$msg}</div>";
        }
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
        echo "</div>";
    }
}
