<?php

namespace view\layouts;

use Error;
use Throwable;
use models\CampGroundSchema;

/**
 * @param array<CampGroundSchema>|CampGroundSchema|Error|Throwable|null $args
 */
function index(string $body, array|CampGroundSchema|Error|Throwable|null $args): void
{
?>
    <!DOCTYPE html>
    <html lang="jp">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>YelpCampPhpDemo</title>
        <link rel="stylesheet" href="<?php echo BASE_CSS_PATH; ?>bootstrap.min.css">
        <link href="https://api.mapbox.com/mapbox-gl-js/v3.9.3/mapbox-gl.css" rel="stylesheet">
        <script src="https://api.mapbox.com/mapbox-gl-js/v3.9.3/mapbox-gl.js"></script>
        <link rel="stylesheet" href="<?php echo BASE_CSS_PATH; ?>app.css">
    </head>

    <body class="d-flex flex-column vh-100">
        <?php \views\partials\navbar(); ?>

        <main class="container mt-5">
            <?php \views\partials\flush(); ?>
            <?php if (is_callable($body)) $body($args); ?>
        </main>

        <?php \views\partials\footer(); ?>

        <script src="<?php echo BASE_JS_PATH ?>bootstrap.bundle.min.js"></script>
        <script src="<?php echo BASE_JS_PATH ?>validateForms.js"></script>
    </body>

    </html>
<?php
}
