<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>YelpCamp デモ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-KyZXEAg3QhqLMpG8r+8fhAXLRk2vvoC2f3B09zVXn8CA5QIVfZOJ3BCsw2P0p/We" crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo BASE_CSS_PATH; ?>home.css">
</head>

<body class="d-flex text-center text-white bg-dark">
    <div class="cover-container d-flex w-100 h-100 p-3 mx-auto flex-column">
        <header class="mb-auto">
            <div>
                <h3 class="float-md-start mb-0">YelpCamp</h3>
                <nav class="nav nav-masthead justify-content-center float-md-end">
                    <a href="#" class="nav-link active">ホーム</a>
                    <a href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds" class="nav-link">キャンプ場</a>
                    <?php if (!middleware\currentUser()) { ?>
                        <a href="<?php echo BASE_CONTEXT_PATH; ?>login" class="nav-link">ログイン</a>
                        <a href="<?php echo BASE_CONTEXT_PATH; ?>register" class="nav-link">ユーザー登録</a>
                    <?php } else { ?>
                        <a href="<?php echo BASE_CONTEXT_PATH; ?>logout" class="nav-link">ログアウト</a>
                    <?php } ?>
                </nav>
            </div>
        </header>
        <main class="px-3">
            <h1>YelpCamp</h1>
            <p class="lead">YelpCampへようこそ！<br> 全国のキャンプ場が簡単に一望できます。 <br>
                キャンプ場の登録やレビューをして交流も深めていきましょう！</p>
            <a href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds" class="btn btn-lg btn-secondary font-weight-bold border-white bg-white">キャンプ場へ</a>
        </main>

        <footer class="mt-auto text-white-50">
            <p>&copy; 2024 YelpCamp</p>
        </footer>
    </div>

    <script src="<?php echo BASE_JS_PATH ?>bootstrap.bundle.min.js"></script>
</body>

</html>