<?php

namespace view\error;

use Error;
use Throwable;

function index(Error|Throwable $error): void
{
    \view\layouts\index("\\view\\error\\content", $error);
}

function content(Error|Throwable $error): void
{
    $message = $error->getMessage();

    if (empty($message)) $message = 'エラーが発生しました。';
?>
    <div class="row">
        <div class="offset-3 col-6">
            <div class="alert alert-danger" role="alert">
                <h4 class="alert-heading"><?php echo $message; ?></h4>
                <?php
                // @phpstan-ignore if.alwaysTrue 
                if (DEBUG) {
                ?>
                    <p><?php echo $error->getTraceAsString(); ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
}
