<?php

namespace view\campgrounds;

use db\CampGroundQuery;
use models\CampGroundSchema;

function index(): void
{
    $campgrounds = CampGroundQuery::select();
    \view\layouts\index("\\view\\campgrounds\\content", $campgrounds);
}

/**
 * @param array<CampGroundSchema> $campgrounds
 */
function content(array $campgrounds): void
{
?>
    <div id="cluster-map"></div>
    <h1>キャンプ場一覧</h1>
    <div>
        <a href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/new">新規登録</a>
    </div>
    <?php foreach ($campgrounds as $campground) { ?>
        <div class="card mb-3">
            <div class="row">
                <div class="col-md-4">
                    <?php if (!empty($campground->images)) { ?>
                        <img class="img-fluid" src="<?php echo BASE_CONTEXT_PATH . $campground->images[0]->filename; ?>" alt="">
                    <?php } else { ?>
                        <img class="img-fluid" src="https://res.cloudinary.com/dwwvtzk17/image/upload/v1632789763/YelpCamp/zqaixbeogpudzuydgspi.jpg" alt="">
                    <?php } ?>
                </div>
                <div class="col-md-8">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $campground->title; ?></h5>
                        <p class="card-text"><?php echo $campground->description; ?></p>
                        <p class="card-text">
                            <small class="text-muted"><?php echo $campground->location; ?></small>
                        </p>
                        <a class="btn btn-primary" href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo $campground->id; ?>"><?php echo $campground->title; ?>の詳細</a>
                    </div>
                </div>
            </div>
        </div>
    <?php }; ?>
    <script>
        const mapToken = '<?php echo MAPBOX_TOKEN; ?>'
        const campgrounds = <?php echo json_encode(getGeoDatas($campgrounds), JSON_UNESCAPED_UNICODE); ?>
    </script>
    <script src="<?php echo BASE_JS_PATH; ?>clusterMap.js"></script>
<?php
}
