<?php

namespace view\campgrounds\edit;

use db\CampGroundQuery;
use models\CampGroundSchema;
use utils\NotFoundException;

use function middleware\currentUser;

function index(int $id): void
{
    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();
    \middleware\isAuthor($campground, currentUser());
    \view\layouts\index("\\view\\campgrounds\\edit\\content", $campground);
}

function content(CampGroundSchema $campground): void
{
?>
    <div class="row">
        <h1 class="text-center">キャンプ場の編集</h1>
        <div class="offset-md-3 col-md-6">
            <form action="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo  $campground->id; ?>?_method=PUT" method="POST" novalidate class="validated-form" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label" for="title">タイトル</label>
                    <input class="form-control" type="text" name="campground[title]" id="title"
                        value="<?php echo  $campground->title; ?>" required>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="location">場所</label>
                    <input class="form-control" type="text" name="campground[location]" id="location"
                        value="<?php echo  $campground->location; ?>" required>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="price">価格</label>
                    <div class="input-group">
                        <span class="input-group-text" id="price-label">¥</span>
                        <input type="text" class="form-control" id="price" placeholder="0" aria-label="価格"
                            aria-describedby="price-label" name="campground[price]" value="<?php echo  $campground->price; ?>"
                            required>
                        <div class="valid-feedback">
                            OK!
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="description">説明</label>
                    <textarea class="form-control" type="text" name="campground[description]" id="description"
                        required><?php echo  $campground->description; ?></textarea>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label for="image" class="form-label">画像の追加アップロード</label>
                    <input class="form-control" type="file" id="image" name="image[]" multiple>
                </div>
                <div class="mb-3">
                    <?php foreach ($campground->images as $i => $img) { ?>
                        <img src="<?php echo BASE_CONTEXT_PATH . $img->thumbnail; ?>" class="img-thumbnail" alt="">
                        <div class="form-check-inline">
                            <input type="checkbox" name="deleteImages[]" id="image-<?php echo $i; ?>" value="<?php echo $img->filename; ?>">
                        </div>
                        <label for="image-<?php echo $i; ?>">削除する</label>
                    <?php } ?>
                </div>
                <div class="mb-3">
                    <button class="btn btn-info">更新する</button>
                </div>

            </form>
            <a href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds">一覧に戻る</a>
        </div>
    </div>
<?php
}
