<?php

declare(strict_types=1);

namespace middleware;

use utils\Flush;
use utils\ReturnTo;
use models\UserSchema;
use models\ReviewSchema;
use models\CampGroundSchema;

function currentUser(): UserSchema|null
{
    $item = UserSchema::getSession();

    if (!is_object($item)) return null;

    $obj = toObject($item);

    return $obj instanceof UserSchema ? UserSchema::cast($obj) : null;
}

function isLoggedIn(?string $current_path = null): UserSchema|null
{
    $user = currentUser();

    if (!isset($user)) {
        if (!empty($current_path)) ReturnTo::push($current_path);
        Flush::push(Flush::ERROR, 'ログインしてください');
        redirect('/login');
    }

    return $user;
}

function isAuthor(?CampGroundSchema $campground, ?UserSchema $user): void
{
    if (!empty($campground) && !$campground->isOwner($user)) {
        ReturnTo::clearSession();
        Flush::push(Flush::ERROR, 'そのアクションの権限がありません');
        redirect("/campgrounds/{$campground->id}");
    }
}

function isReviewAuthor(?CampGroundSchema $campground, ?ReviewSchema $review, ?UserSchema $user): void
{
    if (!empty($campground) && !empty($review) && !$review->isOwner($user)) {
        ReturnTo::clearSession();
        Flush::push(Flush::ERROR, 'そのアクションの権限がありません');
        redirect("/campgrounds/{$campground->id}");
    }
}
