<?php

declare(strict_types=1);

require_once '../config.php';

?>

<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>サンプル作成</title>
    <link rel="stylesheet" href="<?php echo BASE_CONTEXT_PATH; ?>seeds/app.css">
</head>

<body>
    <section id="container">
        <div id="msg"></div>
        <div id="progress-container">
            <div id="progress-bar"></div>
            <span id="progress-text"></span>
        </div>
    </section>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            if (!confirm('データを生成します。よろしいですか？')) {
                history.back();
                return;
            }

            const c = document.getElementById('progress-container');
            const p = document.getElementById('progress-bar');
            const t = document.getElementById('progress-text');
            const msg = document.getElementById('msg');

            const es = new EventSource("<?php echo BASE_CONTEXT_PATH; ?>seeds/seed.php");

            es.onmessage = (e) => {
                if (e.data === "DONE") {
                    msg.textContent = "完了しました！";
                    p.style.width = "100%";
                    es.close();
                    setTimeout(() => location.href = "<?php echo BASE_CONTEXT_PATH; ?>campgrounds", 800);
                    return;
                }

                // "30,データ処理中" のような形式で送られる想定
                const [percent, text] = e.data.split(",", 2);
                if (percent === "0") {
                    c.style.display = 'none';
                } else {
                    c.style.display = 'block';
                }
                p.style.width = percent + "%";
                t.textContent = percent + "%";
                msg.textContent = text ?? "";
            };
        });
    </script>
</body>

</html>