<?php

namespace routes;

use HttpMethod;

function campgrounds(HttpMethod $method, string $rpath): bool
{
    switch (true) {
        case $rpath === 'campgrounds':
            switch ($method) {
                case HttpMethod::GET:
                    \view\campgrounds\index();
                    break;

                case HttpMethod::POST:
                    \controller\campground\createCampground();
                    break;
            }
            break;

        case $rpath === 'campgrounds/new':
            \view\campgrounds\new\index();
            break;

        case preg_match('/campgrounds\/([0-9]+)$/i', $rpath, $match):
            $id = (int)$match[1];

            switch ($method) {
                case HttpMethod::GET:
                    \view\campgrounds\show\index($id);
                    break;

                case HttpMethod::PUT:
                    \controller\campground\updateCampground($id);
                    break;

                case HttpMethod::DELETE:
                    \controller\campground\deleteCampground($id);
                    break;
            }
            break;

        case preg_match('/campgrounds\/([0-9]+)\/edit/i', $rpath, $match):
            $id = (int)$match[1];
            \view\campgrounds\edit\index($id);
            break;

        default:
            return false;
    }

    return true;
}
