<?php

declare(strict_types=1);

namespace models;

use InvalidArgumentException;
use utils\Session;
use utils\YelpCampError;

class UserSchema extends Session
{
    public int $id;
    public string $username;
    public string $email;
    public string $password;

    /**
     * @var string
     */
    protected static $SESSION_NAME = '_user';

    /**
     * @param object $obj
     */
    public static function cast(object $obj): self
    {
        if (!($obj instanceof self)) {
            $name = get_class($obj);
            throw new InvalidArgumentException("{$name} は UserSchema ではありません。");
        }
        return $obj;
    }

    public static function getModel(bool $check_email = true): self
    {
        $username = get_param('username', '');
        $email = get_param('email', '');
        $password = get_param('password', '');

        if (empty($username)) throw new YelpCampError('ユーザー名がありません。');
        if (empty($email) && $check_email) throw new YelpCampError('emailがありません。');
        if (empty($password)) throw new YelpCampError('パスワードがありません。');

        $user = new UserSchema;
        $user->username = $username;
        $user->email = $email;
        $user->password = $password;

        return $user;
    }
}
