<?php

namespace models;

use InvalidArgumentException;

class ImageSchema
{
    public int $id;
    public string $filename;
    public int $camp_id;
    public string $thumbnail;

    /**
     * @param object $obj
     */
    public static function cast(object $obj): self
    {
        if (!($obj instanceof self)) {
            $name = get_class($obj);
            throw new InvalidArgumentException("{$name} は ImageSchema ではありません。");
        }
        return $obj;
    }
}
