<?php

declare(strict_types=1);

namespace db;

use db\DataSource;
use models\UserSchema;

class UserQuery
{
    public static function fetchByUserName(string $username): ?UserSchema
    {
        $db = new DataSource;
        $sql = 'select * from users where username = :username;';

        $result = $db->selectOne($sql, [':username' => $username], DataSource::CLS, UserSchema::class);

        return !empty($result) ? UserSchema::cast($result) : null;
    }

    public static function insert(UserSchema $user): bool
    {
        $db = new DataSource;
        $sql = 'insert into users(username, email, password) values (:username, :email, :password)';

        $user->password = password_hash($user->password, PASSWORD_DEFAULT);

        return $db->execute($sql, [
            ':username' => $user->username,
            ':email' => $user->email,
            ':password' => $user->password,
        ]);
    }
}
