<?php

declare(strict_types=1);

namespace db;

use db\DataSource;
use models\ReviewSchema;

class ReviewQuery
{
    public static function findByIdAndDelete(int $id): bool
    {
        $db = new DataSource;
        $sql = 'delete from reviews where id = :id;';

        return $db->execute($sql, [':id' => $id]);
    }

    public static function findByCampIdAndDelete(int $camp_id): bool
    {
        $db = new DataSource;
        $sql = 'delete from reviews where camp_id = :camp_id;';

        return $db->execute($sql, [':camp_id' => $camp_id]);
    }

    public static function insert(ReviewSchema $review): bool
    {
        $db = new DataSource;
        $sql = 'insert into reviews (body, rating, camp_id, author) values (:body, :rating, :camp_id, :author)';

        return $db->execute($sql, [
            ':body' => $review->body,
            ':rating' => $review->rating,
            ':camp_id' => $review->camp_id,
            ':author' => $review->author,
        ]);
    }

    /**
     * @return array<ReviewSchema>
     */
    public static function select(?string $criteria = null): array
    {
        $db = new DataSource;
        $sql = 'select * from reviews' . (empty($criteria) ? '' : " where {$criteria}");
        $selected = $db->select($sql, [], DataSource::CLS, ReviewSchema::class);
        $results = [];
        if (!empty($selected))
            foreach ($selected as $item)
                array_push($results, ReviewSchema::cast($item));

        return $results;
    }

    public static function findById(int $id): ?ReviewSchema
    {
        $db = new DataSource;
        $sql = 'select * from reviews where id = :id';

        $result = $db->select($sql, [':id' => $id,], DataSource::CLS, ReviewSchema::class);

        return (!empty($result)) ? ReviewSchema::cast($result[0]) : null;
    }

    public static function deleteAll(): bool
    {
        $db  = new DataSource;
        $sql = 'delete from reviews';

        return $db->execute($sql);
    }
}
