<?php

declare(strict_types=1);

namespace db;

use db\DataSource;
use models\ImageSchema;

class ImageQuery
{
    public static function findByCampIdAndDelete(int $camp_id): bool
    {
        $db = new DataSource;
        $sql = 'delete from images where camp_id = :camp_id;';

        return $db->execute($sql, [':camp_id' => $camp_id]);
    }

    /**
     * @param array<string> $filenames
     */
    public static function deleteImages(int $camp_id, array $filenames): bool
    {
        $db = new DataSource;

        foreach ($filenames as $filename) {
            $sql = "delete from images where filename = :filename and camp_id = :camp_id;";
            if (!$db->execute($sql, [':filename' => $filename, ':camp_id' => $camp_id])) return false;
        }
        return true;
    }

    /**
     * @param array<ImageSchema> $images
     */
    public static function save(int $camp_id, array|null $images, bool $exclude_exist = false): bool
    {
        if (!is_array($images) || count($images) === 0) return false;

        foreach ($images as $image) {
            if ($exclude_exist) {
                $criteria = "filename = '{$image->filename}' and camp_id = {$image->camp_id}";
                if (!empty(self::select($criteria))) continue;
            }

            $image->camp_id = $camp_id;
            if (!self::insert($image)) return false;
        }

        return true;
    }

    private static function insert(ImageSchema $image): bool
    {
        $db = new DataSource;
        $sql = 'insert into images (filename, camp_id, thumbnail) values (:filename, :camp_id, :thumbnail)';

        return $db->execute($sql, [
            ':filename' => $image->filename,
            ':camp_id' => $image->camp_id,
            ':thumbnail' => $image->thumbnail,
        ]);
    }

    /**
     * @return array<ImageSchema>
     */
    public static function select(?string $criteria = null)
    {
        $db = new DataSource;
        $sql = 'select * from images' . (empty($criteria) ? '' : " where {$criteria}");
        $selected = $db->select($sql, [], DataSource::CLS, ImageSchema::class);
        $results = [];
        if (!empty($selected))
            foreach ($selected as $item)
                array_push($results, ImageSchema::cast($item));

        return $results;
    }

    public static function deleteAll(): bool
    {
        $db  = new DataSource;
        $sql = 'delete from images';

        return $db->execute($sql);
    }
}
