<?php

namespace controller\users;

use Throwable;
use utils\Flush;
use db\UserQuery;
use utils\ReturnTo;
use models\UserSchema;

function register(): void
{
    try {
        $new_user = UserSchema::getModel();
        $user = UserQuery::fetchByUserName($new_user->username);

        if (!empty($user)) {
            Flush::push(Flush::ERROR, "そのユーザー名はすでに使われています");
            redirect(GO_REFERER);
            return;
        };
        UserQuery::insert($new_user);

        login('Yelp Campへようこそ！');
    } catch (Throwable $e) {
        Flush::push(Flush::ERROR, "エラーが発生しました");
        redirect('/register');
    }
}

function login(string $message = ''): void
{
    $return_path = ReturnTo::pop();
    $req_user = UserSchema::getModel(check_email: false);
    $user = UserQuery::fetchByUserName($req_user->username);

    if (!empty($user)) {
        if (!password_verify($req_user->password, $user->password)) {
            Flush::push(Flush::ERROR, 'パスワードが一致しません');
            redirect('/login');
        }
        UserSchema::setSession($user);
        Flush::push(Flush::INFO, $message);
        redirect($return_path ?? '/campgrounds');
    } else {
        Flush::push(Flush::ERROR, 'ユーザーが見つかりません');
        redirect('/login');
    }
}

function logout(): bool
{
    try {
        UserSchema::clearSession();
    } catch (Throwable $e) {
        Flush::push(Flush::DEBUG, $e->getMessage());
        return false;
    }

    Flush::push(Flush::INFO, 'ログアウトしました');
    redirect('/campgrounds');

    return true;
}
