<?php

namespace views\partials;

use function \middleware\currentUser;

function navbar(): void
{
?>
    <nav class="navbar sticky-top navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo BASE_CONTEXT_PATH; ?>">YelpCamp</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavAltMarkup"
                aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNavAltMarkup">
                <div class="navbar-nav">
                    <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>">ホーム</a>
                    <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds">キャンプ場</a>
                    <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/new">新規登録</a>
                </div>
                <div class="navbar-nav ms-auto">
                    <?php if (!currentUser()) { ?>
                        <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>login">ログイン</a>
                        <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>register">ユーザー登録</a>
                    <?php } else { ?>
                        <a class="nav-link" href="<?php echo BASE_CONTEXT_PATH; ?>logout">ログアウト</a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </nav>
<?php
}
