<?php

namespace view\campgrounds\show;

use db\ReviewQuery;
use db\CampGroundQuery;
use models\CampGroundSchema;
use models\ReviewSchema;
use utils\NotFoundException;

function index(int $id): void
{
    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();
    \view\layouts\index("\\view\\campgrounds\\show\\content", $campground);
}

function content(CampGroundSchema $campground): void
{
    $camp_id = $campground->id;
    $criteria = "camp_id = {$camp_id}";
    $reviews = ReviewQuery::select($criteria);
    $user = \middleware\currentUser();
    $is_author = !empty($user) && $user->username === $campground->author;
?>
    <link rel="stylesheet" href="<?php echo BASE_CSS_PATH; ?>stars.css">

    <div class="row">
        <div class="col-6">
            <div id="campgroundCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php foreach ($campground->images as $i => $image) { ?>
                        <div class="carousel-item <?php echo $i === 0 ? 'active' : '' ?>">
                            <img src="<?php echo BASE_CONTEXT_PATH . $image->filename; ?>" class="d-block w-100" alt="">
                        </div>
                    <?php } ?>
                </div>
                <?php if (count($campground->images) > 0) { ?>
                    <button class="carousel-control-prev" type="button" data-bs-target="#campgroundCarousel"
                        data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#campgroundCarousel"
                        data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                <?php } ?>
            </div>

            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="card-title"><?php echo $campground->title; ?></h5>
                    <p class="card-text"><?php echo $campground->description; ?></p>
                </div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item text-muted"><?php echo $campground->location; ?></li>
                    <li class="list-group-item">登録者：<?php echo $campground->author; ?></li>
                    <li class="list-group-item">¥<?php echo $campground->price; ?>/泊</li>
                </ul>
                <?php if ($is_author) { ?>
                    <div class="card-body">
                        <a class="btn btn-info" href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo $campground->id; ?>/edit">編集する</a>
                        <form class="d-inline" action="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo $campground->id; ?>?_method=DELETE" method="POST">
                            <button class="btn btn-danger">削除する</button>
                        </form>
                    </div>
                <?php } ?>
                <div class="card-footer text-muted">
                    2 days ago
                </div>
            </div>
        </div>
        <div class="col-6">
            <div id="map"></div>
            <?php if (!empty($user)) { ?>
                <h2>レビュー</h2>
                <form action="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo $campground->id; ?>/reviews" method="POST" class="mb-3 validated-form" novalidate>
                    <div>
                        <div>
                            <fieldset class="starability-basic">
                                <input type="radio" id="first-rate1" name="review[rating]" checked value="1" />
                                <label for="first-rate1" title="１">評価1</label>
                                <input type="radio" id="first-rate2" name="review[rating]" value="2" />
                                <label for="first-rate2" title="２">評価2</label>
                                <input type="radio" id="first-rate3" name="review[rating]" value="3" />
                                <label for="first-rate3" title="３">評価3</label>
                                <input type="radio" id="first-rate4" name="review[rating]" value="4" />
                                <label for="first-rate4" title="４">評価4</label>
                                <input type="radio" id="first-rate5" name="review[rating]" value="5" />
                                <label for="first-rate5" title="５">評価5</label>
                            </fieldset>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="body">コメント</label>
                        <textarea class="form-control" name="review[body]" id="body" cols="30" rows="3" required></textarea>
                        <div class="valid-feedback">
                            OK!
                        </div>
                    </div>
                    <button class="btn btn-success">投稿する</button>
                </form>
            <?php } ?>
            <?php foreach ($reviews as $item) {
                $review = ReviewSchema::cast($item);
            ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $review->author; ?></h5>
                        <p class="starability-result" data-rating="<?php echo $review->rating; ?>">
                            評価: <?php echo $review->rating; ?>
                        </p>
                        <p class="card-text">コメント：<?php echo $review->body; ?></p>
                        <?php if ($review->isOwner($user)) { ?>
                            <form action="<?php echo BASE_CONTEXT_PATH; ?>campgrounds/<?php echo $campground->id; ?>/reviews/<?php echo $review->id; ?>?_method=DELETE"
                                method="POST">
                                <button class="btn btn-sm btn-danger">削除する</button>
                            </form>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <script>
        const mapToken = '<?php echo MAPBOX_TOKEN; ?>'
        const campground = <?php echo json_encode($campground->getGeoData(), JSON_UNESCAPED_UNICODE); ?>
    </script>
    <script src="<?php echo BASE_JS_PATH; ?>showPageMap.js"></script>
<?php
}
