<?php

namespace view\campgrounds\new;

use models\CampGroundSchema;

function index(): void
{
    \middleware\isLoggedIn('/campgrounds/new/');

    \view\layouts\index("\\view\\campgrounds\\new\\content", null);
}

function content(null $dummy): void
{
?>
    <div class="row">
        <h1 class="text-center">キャンプ場の新規登録</h1>
        <div class="offset-md-3 col-md-6">
            <form action="<?php echo BASE_CONTEXT_PATH; ?>campgrounds" method="POST" novalidate class="validated-form" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label" for="title">タイトル</label>
                    <input class="form-control" type="text" name="campground[title]" id="title" required>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="location">場所</label>
                    <input class="form-control" type="text" name="campground[location]" id="location" required>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="price">価格</label>
                    <div class="input-group">
                        <span class="input-group-text" id="price-label">¥</span>
                        <input type="text" class="form-control" id="price" placeholder="0" aria-label="価格"
                            aria-describedby="price-label" name="campground[price]" required>
                        <div class="valid-feedback">
                            OK!
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label" for="description">説明</label>
                    <textarea class="form-control" type="text" name="campground[description]" id="description"
                        required></textarea>
                    <div class="valid-feedback">
                        OK!
                    </div>
                </div>
                <div class="mb-3">
                    <label for="image" class="form-label">画像のアップロード</label>
                    <input class="form-control" type="file" id="image" name="image[]" multiple>
                </div>
                <div class="mb-3">
                    <button class="btn btn-success">登録する</button>
                </div>

            </form>
            <a href="<?php echo BASE_CONTEXT_PATH; ?>campgrounds">一覧に戻る</a>
        </div>
    </div>
<?php
}
