<?php

namespace utils;

use Error;

abstract class Session
{

    /**
     * @var ?string
     */
    protected static $SESSION_NAME = null;

    public static function setSession(mixed $val): void
    {
        if (empty(static::$SESSION_NAME)) {
            throw new Error('$SESSION_NAMEを設定していください。');
        }

        $_SESSION[static::$SESSION_NAME] = $val;
    }

    /**
     * @return array<mixed, mixed>
     */
    public static function getSession(): array|object|string|null
    {
        $item = $_SESSION[static::$SESSION_NAME];

        switch (true) {
            case is_array($item):
                return (array)$item;
            case is_string($item):
                return strval($item);
            case is_object($item):
                return (object)$item;
            default:
                return null;
        }
    }

    public static function clearSession(): void
    {
        static::setSession(null);
    }

    /**
     * @return array<int|string, mixed>
     */
    public static function getSessionAndFlush(): array|object|string|null
    {
        try {
            return static::getSession();
        } finally {
            static::clearSession();
        }
    }
}
