<?php

namespace utils;

use utils\Session;
use Throwable;

class ReturnTo extends Session
{
    /**
     * @var string
     */
    protected static $SESSION_NAME = '_returnTo';

    public static function push(string $msg): void
    {
        static::setSession($msg);
    }

    public static function pop(): ?string
    {
        try {
            $item = static::getSessionAndFlush();
            return is_string($item) ? toString($item) : null;
        } catch (Throwable $e) {
            Flush::push(Flush::DEBUG, $e->getMessage());
            Flush::push(Flush::DEBUG, 'ReturnTo::popで例外が発生しました。');
        }
        return null;
    }
}
