<?php

namespace utils;

use models\UserSchema;
use utils\Session;
use Throwable;

class Flush extends Session
{
    /**
     * @var string
     */
    protected static $SESSION_NAME = '_msg';
    public const ERROR = 'error';
    public const INFO = 'info';
    public const DEBUG = 'debug';

    public static function push(string $type, string $msg): void
    {
        if (!is_array(static::getSession())) {
            self::init();
        }

        $msgs = (array)static::getSession();
        $msgs[$type][] = $msg;
        static::setSession($msgs);
    }

    public static function pop(): mixed
    {
        try {
            return static::getSessionAndFlush() ?? [];
        } catch (Throwable $e) {
            Flush::push(Flush::DEBUG, $e->getMessage());
            Flush::push(Flush::DEBUG, 'Flush::popで例外が発生しました。');
        }
        return [];
    }

    private static function init(): void
    {
        static::setSession([
            self::ERROR => [],
            self::INFO => [],
            self::DEBUG => []
        ]);
    }
}
