<?php  //[STAMP] 91ebb48401b9c6ef0214116cf6432910
// phpcs:ignoreFile
namespace Tests\Support\_generated;

// This class was automatically generated by build task
// You should not change it manually as it will be overwritten on next build

trait AcceptanceTesterActions
{
    /**
     * @return \Codeception\Scenario
     */
    abstract protected function getScenario();

    
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Alias to `haveHttpHeader`
     * @see \Codeception\Module\PhpBrowser::setHeader()
     */
    public function setHeader(string $name, string $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('setHeader', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Alias to `haveHttpHeader`
     * @see \Codeception\Module\PhpBrowser::setHeader()
     */
    public function tryToSetHeader(string $name, string $value): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('setHeader', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes setHeader and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Module\PhpBrowser::setHeader()
     */
    public function retrySetHeader(string $name, string $value) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('setHeader', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Authenticates user for HTTP_AUTH
     * @see \Codeception\Module\PhpBrowser::amHttpAuthenticated()
     */
    public function amHttpAuthenticated(string $username, string $password): void {
        $this->getScenario()->runStep(new \Codeception\Step\Condition('amHttpAuthenticated', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Open web page at the given absolute URL and sets its hostname as the base host.
     *
     * ``` php
     * <?php
     * $I->amOnUrl('https://codeception.com');
     * $I->amOnPage('/quickstart'); // moves to https://codeception.com/quickstart
     * ```
     * @see \Codeception\Module\PhpBrowser::amOnUrl()
     */
    public function amOnUrl(string $url): void {
        $this->getScenario()->runStep(new \Codeception\Step\Condition('amOnUrl', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Changes the subdomain for the 'url' configuration parameter.
     * Does not open a page; use `amOnPage` for that.
     *
     * ``` php
     * <?php
     * // If config is: 'https://mysite.com'
     * // or config is: 'https://www.mysite.com'
     * // or config is: 'https://company.mysite.com'
     *
     * $I->amOnSubdomain('user');
     * $I->amOnPage('/');
     * // moves to https://user.mysite.com/
     * ```
     *
     * @see \Codeception\Module\PhpBrowser::amOnSubdomain()
     */
    public function amOnSubdomain(string $subdomain): void {
        $this->getScenario()->runStep(new \Codeception\Step\Condition('amOnSubdomain', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Low-level API method.
     * If Codeception commands are not enough, use [Guzzle HTTP Client](https://guzzlephp.org/) methods directly
     *
     * Example:
     *
     * ``` php
     * <?php
     * $I->executeInGuzzle(function (\GuzzleHttp\Client $client) {
     *      $client->get('/get', ['query' => ['foo' => 'bar']]);
     * });
     * ```
     *
     * It is not recommended to use this command on a regular basis.
     * If Codeception lacks important Guzzle Client methods, implement them and submit patches.
     * @see \Codeception\Module\PhpBrowser::executeInGuzzle()
     */
    public function executeInGuzzle(\Closure $function): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('executeInGuzzle', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Low-level API method.
     * If Codeception commands are not enough, use [Guzzle HTTP Client](https://guzzlephp.org/) methods directly
     *
     * Example:
     *
     * ``` php
     * <?php
     * $I->executeInGuzzle(function (\GuzzleHttp\Client $client) {
     *      $client->get('/get', ['query' => ['foo' => 'bar']]);
     * });
     * ```
     *
     * It is not recommended to use this command on a regular basis.
     * If Codeception lacks important Guzzle Client methods, implement them and submit patches.
     * @see \Codeception\Module\PhpBrowser::executeInGuzzle()
     */
    public function tryToExecuteInGuzzle(\Closure $function): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('executeInGuzzle', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes executeInGuzzle and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Module\PhpBrowser::executeInGuzzle()
     */
    public function retryExecuteInGuzzle(\Closure $function) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('executeInGuzzle', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sets the HTTP header to the passed value - which is used on
     * subsequent HTTP requests through PhpBrowser.
     *
     * Example:
     * ```php
     * <?php
     * $I->haveHttpHeader('X-Requested-With', 'Codeception');
     * $I->amOnPage('test-headers.php');
     * ```
     *
     * To use special chars in Header Key use HTML Character Entities:
     * Example:
     * Header with underscore - 'Client_Id'
     * should be represented as - 'Client&#x0005F;Id' or 'Client&#95;Id'
     *
     * ```php
     * <?php
     * $I->haveHttpHeader('Client&#95;Id', 'Codeception');
     * ```
     *
     * @param string $name the name of the request header
     * @param string $value the value to set it to for subsequent
     *        requests
     * @see \Codeception\Lib\InnerBrowser::haveHttpHeader()
     */
    public function haveHttpHeader(string $name, string $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('haveHttpHeader', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Unsets a HTTP header (that was originally added by [haveHttpHeader()](#haveHttpHeader)),
     * so that subsequent requests will not send it anymore.
     *
     * Example:
     * ```php
     * <?php
     * $I->haveHttpHeader('X-Requested-With', 'Codeception');
     * $I->amOnPage('test-headers.php');
     * // ...
     * $I->unsetHeader('X-Requested-With');
     * $I->amOnPage('some-other-page.php');
     * ```
     *
     * @param string $name the name of the header to unset.
     * @see \Codeception\Lib\InnerBrowser::unsetHttpHeader()
     */
    public function unsetHttpHeader(string $name): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('unsetHttpHeader', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Unsets a HTTP header (that was originally added by [haveHttpHeader()](#haveHttpHeader)),
     * so that subsequent requests will not send it anymore.
     *
     * Example:
     * ```php
     * <?php
     * $I->haveHttpHeader('X-Requested-With', 'Codeception');
     * $I->amOnPage('test-headers.php');
     * // ...
     * $I->unsetHeader('X-Requested-With');
     * $I->amOnPage('some-other-page.php');
     * ```
     *
     * @param string $name the name of the header to unset.
     * @see \Codeception\Lib\InnerBrowser::unsetHttpHeader()
     */
    public function tryToUnsetHttpHeader(string $name): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('unsetHttpHeader', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes unsetHttpHeader and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::unsetHttpHeader()
     */
    public function retryUnsetHttpHeader(string $name) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('unsetHttpHeader', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * @deprecated Use [unsetHttpHeader](#unsetHttpHeader) instead
     * @see \Codeception\Lib\InnerBrowser::deleteHeader()
     */
    public function deleteHeader(string $name): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('deleteHeader', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * @deprecated Use [unsetHttpHeader](#unsetHttpHeader) instead
     * @see \Codeception\Lib\InnerBrowser::deleteHeader()
     */
    public function tryToDeleteHeader(string $name): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('deleteHeader', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes deleteHeader and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::deleteHeader()
     */
    public function retryDeleteHeader(string $name) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('deleteHeader', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Opens the page for the given relative URI.
     *
     * ```php
     * <?php
     * // opens front page
     * $I->amOnPage('/');
     * // opens /register page
     * $I->amOnPage('/register');
     * ```
     * @see \Codeception\Lib\InnerBrowser::amOnPage()
     */
    public function amOnPage(string $page): void {
        $this->getScenario()->runStep(new \Codeception\Step\Condition('amOnPage', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Perform a click on a link or a button, given by a locator.
     * If a fuzzy locator is given, the page will be searched for a button, link, or image matching the locator string.
     * For buttons, the "value" attribute, "name" attribute, and inner text are searched.
     * For links, the link text is searched.
     * For images, the "alt" attribute and inner text of any parent links are searched.
     *
     * The second parameter is a context (CSS or XPath locator) to narrow the search.
     *
     * Note that if the locator matches a button of type `submit`, the form will be submitted.
     *
     * ```php
     * <?php
     * // simple link
     * $I->click('Logout');
     * // button of form
     * $I->click('Submit');
     * // CSS button
     * $I->click('#form input[type=submit]');
     * // XPath
     * $I->click('//form/*[@type="submit"]');
     * // link in context
     * $I->click('Logout', '#nav');
     * // using strict locator
     * $I->click(['link' => 'Login']);
     * ```
     * @param string|array $link
     * @see \Codeception\Lib\InnerBrowser::click()
     */
    public function click($link, $context = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('click', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Perform a click on a link or a button, given by a locator.
     * If a fuzzy locator is given, the page will be searched for a button, link, or image matching the locator string.
     * For buttons, the "value" attribute, "name" attribute, and inner text are searched.
     * For links, the link text is searched.
     * For images, the "alt" attribute and inner text of any parent links are searched.
     *
     * The second parameter is a context (CSS or XPath locator) to narrow the search.
     *
     * Note that if the locator matches a button of type `submit`, the form will be submitted.
     *
     * ```php
     * <?php
     * // simple link
     * $I->click('Logout');
     * // button of form
     * $I->click('Submit');
     * // CSS button
     * $I->click('#form input[type=submit]');
     * // XPath
     * $I->click('//form/*[@type="submit"]');
     * // link in context
     * $I->click('Logout', '#nav');
     * // using strict locator
     * $I->click(['link' => 'Login']);
     * ```
     * @param string|array $link
     * @see \Codeception\Lib\InnerBrowser::click()
     */
    public function tryToClick($link, $context = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('click', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes click and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::click()
     */
    public function retryClick($link, $context = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('click', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current page contains the given string (case insensitive).
     *
     * You can specify a specific HTML element (via CSS or XPath) as the second
     * parameter to only search within that element.
     *
     * ```php
     * <?php
     * $I->see('Logout');                        // I can suppose user is logged in
     * $I->see('Sign Up', 'h1');                 // I can suppose it's a signup page
     * $I->see('Sign Up', '//body/h1');          // with XPath
     * $I->see('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->see('strong')` will return true for strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will *not* be true for strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::see()
     */
    public function see(string $text, $selector = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('see', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current page contains the given string (case insensitive).
     *
     * You can specify a specific HTML element (via CSS or XPath) as the second
     * parameter to only search within that element.
     *
     * ```php
     * <?php
     * $I->see('Logout');                        // I can suppose user is logged in
     * $I->see('Sign Up', 'h1');                 // I can suppose it's a signup page
     * $I->see('Sign Up', '//body/h1');          // with XPath
     * $I->see('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->see('strong')` will return true for strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will *not* be true for strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::see()
     */
    public function canSee(string $text, $selector = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('see', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current page contains the given string (case insensitive).
     *
     * You can specify a specific HTML element (via CSS or XPath) as the second
     * parameter to only search within that element.
     *
     * ```php
     * <?php
     * $I->see('Logout');                        // I can suppose user is logged in
     * $I->see('Sign Up', 'h1');                 // I can suppose it's a signup page
     * $I->see('Sign Up', '//body/h1');          // with XPath
     * $I->see('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->see('strong')` will return true for strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will *not* be true for strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::see()
     */
    public function tryToSee(string $text, $selector = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('see', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes see and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::see()
     */
    public function retrySee(string $text, $selector = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('see', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current page doesn't contain the text specified (case insensitive).
     * Give a locator as the second parameter to match a specific region.
     *
     * ```php
     * <?php
     * $I->dontSee('Login');                         // I can suppose user is already logged in
     * $I->dontSee('Sign Up','h1');                  // I can suppose it's not a signup page
     * $I->dontSee('Sign Up','//body/h1');           // with XPath
     * $I->dontSee('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->dontSee('strong')` will fail on strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will ignore strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::dontSee()
     */
    public function dontSee(string $text, $selector = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSee', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current page doesn't contain the text specified (case insensitive).
     * Give a locator as the second parameter to match a specific region.
     *
     * ```php
     * <?php
     * $I->dontSee('Login');                         // I can suppose user is already logged in
     * $I->dontSee('Sign Up','h1');                  // I can suppose it's not a signup page
     * $I->dontSee('Sign Up','//body/h1');           // with XPath
     * $I->dontSee('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->dontSee('strong')` will fail on strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will ignore strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::dontSee()
     */
    public function cantSee(string $text, $selector = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSee', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current page doesn't contain the text specified (case insensitive).
     * Give a locator as the second parameter to match a specific region.
     *
     * ```php
     * <?php
     * $I->dontSee('Login');                         // I can suppose user is already logged in
     * $I->dontSee('Sign Up','h1');                  // I can suppose it's not a signup page
     * $I->dontSee('Sign Up','//body/h1');           // with XPath
     * $I->dontSee('Sign Up', ['css' => 'body h1']); // with strict CSS locator
     * ```
     *
     * Note that the search is done after stripping all HTML tags from the body,
     * so `$I->dontSee('strong')` will fail on strings like:
     *
     *   - `<p>I am Stronger than thou</p>`
     *   - `<script>document.createElement('strong');</script>`
     *
     * But will ignore strings like:
     *
     *   - `<strong>Home</strong>`
     *   - `<div class="strong">Home</strong>`
     *   - `<!-- strong -->`
     *
     * For checking the raw source code, use `seeInSource()`.
     *
     * @param array|string $selector optional
     * @see \Codeception\Lib\InnerBrowser::dontSee()
     */
    public function tryToDontSee(string $text, $selector = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSee', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSee and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSee()
     */
    public function retryDontSee(string $text, $selector = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSee', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->seeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInSource()
     */
    public function seeInSource(string $raw): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->seeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInSource()
     */
    public function canSeeInSource(string $raw): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->seeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInSource()
     */
    public function tryToSeeInSource(string $raw): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeInSource and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeInSource()
     */
    public function retrySeeInSource(string $raw) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeInSource', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->dontSeeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInSource()
     */
    public function dontSeeInSource(string $raw): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->dontSeeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInSource()
     */
    public function cantSeeInSource(string $raw): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current page contains the given string in its
     * raw source code.
     *
     * ```php
     * <?php
     * $I->dontSeeInSource('<h1>Green eggs &amp; ham</h1>');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInSource()
     */
    public function tryToDontSeeInSource(string $raw): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeInSource', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeInSource and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeInSource()
     */
    public function retryDontSeeInSource(string $raw) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeInSource', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that there's a link with the specified text.
     * Give a full URL as the second parameter to match links with that exact URL.
     *
     * ```php
     * <?php
     * $I->seeLink('Logout'); // matches <a href="#">Logout</a>
     * $I->seeLink('Logout','/logout'); // matches <a href="/logout">Logout</a>
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeLink()
     */
    public function seeLink(string $text, ?string $url = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeLink', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that there's a link with the specified text.
     * Give a full URL as the second parameter to match links with that exact URL.
     *
     * ```php
     * <?php
     * $I->seeLink('Logout'); // matches <a href="#">Logout</a>
     * $I->seeLink('Logout','/logout'); // matches <a href="/logout">Logout</a>
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeLink()
     */
    public function canSeeLink(string $text, ?string $url = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeLink', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that there's a link with the specified text.
     * Give a full URL as the second parameter to match links with that exact URL.
     *
     * ```php
     * <?php
     * $I->seeLink('Logout'); // matches <a href="#">Logout</a>
     * $I->seeLink('Logout','/logout'); // matches <a href="/logout">Logout</a>
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeLink()
     */
    public function tryToSeeLink(string $text, ?string $url = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeLink', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeLink and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeLink()
     */
    public function retrySeeLink(string $text, ?string $url = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeLink', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the page doesn't contain a link with the given string.
     * If the second parameter is given, only links with a matching "href" attribute will be checked.
     *
     * ```php
     * <?php
     * $I->dontSeeLink('Logout'); // I suppose user is not logged in
     * $I->dontSeeLink('Checkout now', '/store/cart.php');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeLink()
     */
    public function dontSeeLink(string $text, string $url = ""): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeLink', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the page doesn't contain a link with the given string.
     * If the second parameter is given, only links with a matching "href" attribute will be checked.
     *
     * ```php
     * <?php
     * $I->dontSeeLink('Logout'); // I suppose user is not logged in
     * $I->dontSeeLink('Checkout now', '/store/cart.php');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeLink()
     */
    public function cantSeeLink(string $text, string $url = ""): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeLink', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the page doesn't contain a link with the given string.
     * If the second parameter is given, only links with a matching "href" attribute will be checked.
     *
     * ```php
     * <?php
     * $I->dontSeeLink('Logout'); // I suppose user is not logged in
     * $I->dontSeeLink('Checkout now', '/store/cart.php');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeLink()
     */
    public function tryToDontSeeLink(string $text, string $url = ""): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeLink', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeLink and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeLink()
     */
    public function retryDontSeeLink(string $text, string $url = "") {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeLink', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that current URI contains the given string.
     *
     * ```php
     * <?php
     * // to match: /home/dashboard
     * $I->seeInCurrentUrl('home');
     * // to match: /users/1
     * $I->seeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInCurrentUrl()
     */
    public function seeInCurrentUrl(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that current URI contains the given string.
     *
     * ```php
     * <?php
     * // to match: /home/dashboard
     * $I->seeInCurrentUrl('home');
     * // to match: /users/1
     * $I->seeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInCurrentUrl()
     */
    public function canSeeInCurrentUrl(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that current URI contains the given string.
     *
     * ```php
     * <?php
     * // to match: /home/dashboard
     * $I->seeInCurrentUrl('home');
     * // to match: /users/1
     * $I->seeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInCurrentUrl()
     */
    public function tryToSeeInCurrentUrl(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeInCurrentUrl and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeInCurrentUrl()
     */
    public function retrySeeInCurrentUrl(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeInCurrentUrl', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current URI doesn't contain the given string.
     *
     * ```php
     * <?php
     * $I->dontSeeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInCurrentUrl()
     */
    public function dontSeeInCurrentUrl(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current URI doesn't contain the given string.
     *
     * ```php
     * <?php
     * $I->dontSeeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInCurrentUrl()
     */
    public function cantSeeInCurrentUrl(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current URI doesn't contain the given string.
     *
     * ```php
     * <?php
     * $I->dontSeeInCurrentUrl('/users/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInCurrentUrl()
     */
    public function tryToDontSeeInCurrentUrl(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeInCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeInCurrentUrl and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeInCurrentUrl()
     */
    public function retryDontSeeInCurrentUrl(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeInCurrentUrl', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current URL is equal to the given string.
     * Unlike `seeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlEquals()
     */
    public function seeCurrentUrlEquals(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current URL is equal to the given string.
     * Unlike `seeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlEquals()
     */
    public function canSeeCurrentUrlEquals(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current URL is equal to the given string.
     * Unlike `seeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlEquals()
     */
    public function tryToSeeCurrentUrlEquals(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeCurrentUrlEquals and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlEquals()
     */
    public function retrySeeCurrentUrlEquals(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeCurrentUrlEquals', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current URL doesn't equal the given string.
     * Unlike `dontSeeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // current url is not root
     * $I->dontSeeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlEquals()
     */
    public function dontSeeCurrentUrlEquals(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current URL doesn't equal the given string.
     * Unlike `dontSeeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // current url is not root
     * $I->dontSeeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlEquals()
     */
    public function cantSeeCurrentUrlEquals(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current URL doesn't equal the given string.
     * Unlike `dontSeeInCurrentUrl`, this only matches the full URL.
     *
     * ```php
     * <?php
     * // current url is not root
     * $I->dontSeeCurrentUrlEquals('/');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlEquals()
     */
    public function tryToDontSeeCurrentUrlEquals(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeCurrentUrlEquals', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeCurrentUrlEquals and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlEquals()
     */
    public function retryDontSeeCurrentUrlEquals(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeCurrentUrlEquals', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the current URL matches the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlMatches()
     */
    public function seeCurrentUrlMatches(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the current URL matches the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlMatches()
     */
    public function canSeeCurrentUrlMatches(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the current URL matches the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->seeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlMatches()
     */
    public function tryToSeeCurrentUrlMatches(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeCurrentUrlMatches and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeCurrentUrlMatches()
     */
    public function retrySeeCurrentUrlMatches(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeCurrentUrlMatches', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that current url doesn't match the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->dontSeeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlMatches()
     */
    public function dontSeeCurrentUrlMatches(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that current url doesn't match the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->dontSeeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlMatches()
     */
    public function cantSeeCurrentUrlMatches(string $uri): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that current url doesn't match the given regular expression.
     *
     * ```php
     * <?php
     * // to match root url
     * $I->dontSeeCurrentUrlMatches('~^/users/(\d+)~');
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlMatches()
     */
    public function tryToDontSeeCurrentUrlMatches(string $uri): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeCurrentUrlMatches', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeCurrentUrlMatches and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeCurrentUrlMatches()
     */
    public function retryDontSeeCurrentUrlMatches(string $uri) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeCurrentUrlMatches', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Executes the given regular expression against the current URI and returns the first capturing group.
     * If no parameters are provided, the full URI is returned.
     *
     * ```php
     * <?php
     * $user_id = $I->grabFromCurrentUrl('~^/user/(\d+)/~');
     * $uri = $I->grabFromCurrentUrl();
     * ```
     * @see \Codeception\Lib\InnerBrowser::grabFromCurrentUrl()
     */
    public function grabFromCurrentUrl(?string $uri = NULL): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabFromCurrentUrl', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabFromCurrentUrl and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabFromCurrentUrl()
     */
    public function retryGrabFromCurrentUrl(?string $uri = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabFromCurrentUrl', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the specified checkbox is checked.
     *
     * ```php
     * <?php
     * $I->seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user agreed to terms, If there is only one checkbox in form.
     * $I->seeCheckboxIsChecked('//form/input[@type=checkbox and @name=agree]');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCheckboxIsChecked()
     */
    public function seeCheckboxIsChecked($checkbox): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the specified checkbox is checked.
     *
     * ```php
     * <?php
     * $I->seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user agreed to terms, If there is only one checkbox in form.
     * $I->seeCheckboxIsChecked('//form/input[@type=checkbox and @name=agree]');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCheckboxIsChecked()
     */
    public function canSeeCheckboxIsChecked($checkbox): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the specified checkbox is checked.
     *
     * ```php
     * <?php
     * $I->seeCheckboxIsChecked('#agree'); // I suppose user agreed to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user agreed to terms, If there is only one checkbox in form.
     * $I->seeCheckboxIsChecked('//form/input[@type=checkbox and @name=agree]');
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeCheckboxIsChecked()
     */
    public function tryToSeeCheckboxIsChecked($checkbox): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeCheckboxIsChecked and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeCheckboxIsChecked()
     */
    public function retrySeeCheckboxIsChecked($checkbox) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeCheckboxIsChecked', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Check that the specified checkbox is unchecked.
     *
     * ```php
     * <?php
     * $I->dontSeeCheckboxIsChecked('#agree'); // I suppose user didn't agree to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user didn't check the first checkbox in form.
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCheckboxIsChecked()
     */
    public function dontSeeCheckboxIsChecked($checkbox): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Check that the specified checkbox is unchecked.
     *
     * ```php
     * <?php
     * $I->dontSeeCheckboxIsChecked('#agree'); // I suppose user didn't agree to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user didn't check the first checkbox in form.
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCheckboxIsChecked()
     */
    public function cantSeeCheckboxIsChecked($checkbox): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Check that the specified checkbox is unchecked.
     *
     * ```php
     * <?php
     * $I->dontSeeCheckboxIsChecked('#agree'); // I suppose user didn't agree to terms
     * $I->seeCheckboxIsChecked('#signup_form input[type=checkbox]'); // I suppose user didn't check the first checkbox in form.
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeCheckboxIsChecked()
     */
    public function tryToDontSeeCheckboxIsChecked($checkbox): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeCheckboxIsChecked', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeCheckboxIsChecked and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeCheckboxIsChecked()
     */
    public function retryDontSeeCheckboxIsChecked($checkbox) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeCheckboxIsChecked', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the given input field or textarea *equals* (i.e. not just contains) the given value.
     * Fields are matched by label text, the "name" attribute, CSS, or XPath.
     *
     * ```php
     * <?php
     * $I->seeInField('Body','Type your comment here');
     * $I->seeInField('form textarea[name=body]','Type your comment here');
     * $I->seeInField('form input[type=hidden]','hidden_value');
     * $I->seeInField('#searchform input','Search');
     * $I->seeInField('//form/*[@name=search]','Search');
     * $I->seeInField(['name' => 'search'], 'Search');
     * ```
     *
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::seeInField()
     */
    public function seeInField($field, $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeInField', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the given input field or textarea *equals* (i.e. not just contains) the given value.
     * Fields are matched by label text, the "name" attribute, CSS, or XPath.
     *
     * ```php
     * <?php
     * $I->seeInField('Body','Type your comment here');
     * $I->seeInField('form textarea[name=body]','Type your comment here');
     * $I->seeInField('form input[type=hidden]','hidden_value');
     * $I->seeInField('#searchform input','Search');
     * $I->seeInField('//form/*[@name=search]','Search');
     * $I->seeInField(['name' => 'search'], 'Search');
     * ```
     *
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::seeInField()
     */
    public function canSeeInField($field, $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeInField', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the given input field or textarea *equals* (i.e. not just contains) the given value.
     * Fields are matched by label text, the "name" attribute, CSS, or XPath.
     *
     * ```php
     * <?php
     * $I->seeInField('Body','Type your comment here');
     * $I->seeInField('form textarea[name=body]','Type your comment here');
     * $I->seeInField('form input[type=hidden]','hidden_value');
     * $I->seeInField('#searchform input','Search');
     * $I->seeInField('//form/*[@name=search]','Search');
     * $I->seeInField(['name' => 'search'], 'Search');
     * ```
     *
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::seeInField()
     */
    public function tryToSeeInField($field, $value): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeInField', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeInField and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeInField()
     */
    public function retrySeeInField($field, $value) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeInField', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that an input field or textarea doesn't contain the given value.
     * For fuzzy locators, the field is matched by label text, CSS and XPath.
     *
     * ```php
     * <?php
     * $I->dontSeeInField('Body','Type your comment here');
     * $I->dontSeeInField('form textarea[name=body]','Type your comment here');
     * $I->dontSeeInField('form input[type=hidden]','hidden_value');
     * $I->dontSeeInField('#searchform input','Search');
     * $I->dontSeeInField('//form/*[@name=search]','Search');
     * $I->dontSeeInField(['name' => 'search'], 'Search');
     * ```
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::dontSeeInField()
     */
    public function dontSeeInField($field, $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeInField', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that an input field or textarea doesn't contain the given value.
     * For fuzzy locators, the field is matched by label text, CSS and XPath.
     *
     * ```php
     * <?php
     * $I->dontSeeInField('Body','Type your comment here');
     * $I->dontSeeInField('form textarea[name=body]','Type your comment here');
     * $I->dontSeeInField('form input[type=hidden]','hidden_value');
     * $I->dontSeeInField('#searchform input','Search');
     * $I->dontSeeInField('//form/*[@name=search]','Search');
     * $I->dontSeeInField(['name' => 'search'], 'Search');
     * ```
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::dontSeeInField()
     */
    public function cantSeeInField($field, $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeInField', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that an input field or textarea doesn't contain the given value.
     * For fuzzy locators, the field is matched by label text, CSS and XPath.
     *
     * ```php
     * <?php
     * $I->dontSeeInField('Body','Type your comment here');
     * $I->dontSeeInField('form textarea[name=body]','Type your comment here');
     * $I->dontSeeInField('form input[type=hidden]','hidden_value');
     * $I->dontSeeInField('#searchform input','Search');
     * $I->dontSeeInField('//form/*[@name=search]','Search');
     * $I->dontSeeInField(['name' => 'search'], 'Search');
     * ```
     * @param string|array $field
     * @see \Codeception\Lib\InnerBrowser::dontSeeInField()
     */
    public function tryToDontSeeInField($field, $value): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeInField', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeInField and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeInField()
     */
    public function retryDontSeeInField($field, $value) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeInField', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks if the array of form parameters (name => value) are set on the form matched with the
     * passed selector.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('form[name=myform]', [
     *      'input1' => 'value',
     *      'input2' => 'other value',
     * ]);
     * ```
     *
     * For multi-select elements, or to check values of multiple elements with the same name, an
     * array may be passed:
     *
     * ```php
     * <?php
     * $I->seeInFormFields('.form-class', [
     *      'multiselect' => [
     *          'value1',
     *          'value2',
     *      ],
     *      'checkbox[]' => [
     *          'a checked value',
     *          'another checked value',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('#form-id', [
     *      'checkbox1' => true,        // passes if checked
     *      'checkbox2' => false,       // passes if unchecked
     * ]);
     * ```
     *
     * Pair this with submitForm for quick testing magic.
     *
     * ```php
     * <?php
     * $form = [
     *      'field1' => 'value',
     *      'field2' => 'another value',
     *      'checkbox1' => true,
     *      // ...
     * ];
     * $I->submitForm('//form[@id=my-form]', string $form, 'submitButton');
     * // $I->amOnPage('/path/to/form-page') may be needed
     * $I->seeInFormFields('//form[@id=my-form]', string $form);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInFormFields()
     */
    public function seeInFormFields($formSelector, array $params): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks if the array of form parameters (name => value) are set on the form matched with the
     * passed selector.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('form[name=myform]', [
     *      'input1' => 'value',
     *      'input2' => 'other value',
     * ]);
     * ```
     *
     * For multi-select elements, or to check values of multiple elements with the same name, an
     * array may be passed:
     *
     * ```php
     * <?php
     * $I->seeInFormFields('.form-class', [
     *      'multiselect' => [
     *          'value1',
     *          'value2',
     *      ],
     *      'checkbox[]' => [
     *          'a checked value',
     *          'another checked value',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('#form-id', [
     *      'checkbox1' => true,        // passes if checked
     *      'checkbox2' => false,       // passes if unchecked
     * ]);
     * ```
     *
     * Pair this with submitForm for quick testing magic.
     *
     * ```php
     * <?php
     * $form = [
     *      'field1' => 'value',
     *      'field2' => 'another value',
     *      'checkbox1' => true,
     *      // ...
     * ];
     * $I->submitForm('//form[@id=my-form]', string $form, 'submitButton');
     * // $I->amOnPage('/path/to/form-page') may be needed
     * $I->seeInFormFields('//form[@id=my-form]', string $form);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInFormFields()
     */
    public function canSeeInFormFields($formSelector, array $params): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks if the array of form parameters (name => value) are set on the form matched with the
     * passed selector.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('form[name=myform]', [
     *      'input1' => 'value',
     *      'input2' => 'other value',
     * ]);
     * ```
     *
     * For multi-select elements, or to check values of multiple elements with the same name, an
     * array may be passed:
     *
     * ```php
     * <?php
     * $I->seeInFormFields('.form-class', [
     *      'multiselect' => [
     *          'value1',
     *          'value2',
     *      ],
     *      'checkbox[]' => [
     *          'a checked value',
     *          'another checked value',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->seeInFormFields('#form-id', [
     *      'checkbox1' => true,        // passes if checked
     *      'checkbox2' => false,       // passes if unchecked
     * ]);
     * ```
     *
     * Pair this with submitForm for quick testing magic.
     *
     * ```php
     * <?php
     * $form = [
     *      'field1' => 'value',
     *      'field2' => 'another value',
     *      'checkbox1' => true,
     *      // ...
     * ];
     * $I->submitForm('//form[@id=my-form]', string $form, 'submitButton');
     * // $I->amOnPage('/path/to/form-page') may be needed
     * $I->seeInFormFields('//form[@id=my-form]', string $form);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeInFormFields()
     */
    public function tryToSeeInFormFields($formSelector, array $params): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeInFormFields and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeInFormFields()
     */
    public function retrySeeInFormFields($formSelector, array $params) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeInFormFields', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks if the array of form parameters (name => value) are not set on the form matched with
     * the passed selector.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('form[name=myform]', [
     *      'input1' => 'non-existent value',
     *      'input2' => 'other non-existent value',
     * ]);
     * ```
     *
     * To check that an element hasn't been assigned any one of many values, an array can be passed
     * as the value:
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('.form-class', [
     *      'fieldName' => [
     *          'This value shouldn\'t be set',
     *          'And this value shouldn\'t be set',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('#form-id', [
     *      'checkbox1' => true,        // fails if checked
     *      'checkbox2' => false,       // fails if unchecked
     * ]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInFormFields()
     */
    public function dontSeeInFormFields($formSelector, array $params): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks if the array of form parameters (name => value) are not set on the form matched with
     * the passed selector.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('form[name=myform]', [
     *      'input1' => 'non-existent value',
     *      'input2' => 'other non-existent value',
     * ]);
     * ```
     *
     * To check that an element hasn't been assigned any one of many values, an array can be passed
     * as the value:
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('.form-class', [
     *      'fieldName' => [
     *          'This value shouldn\'t be set',
     *          'And this value shouldn\'t be set',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('#form-id', [
     *      'checkbox1' => true,        // fails if checked
     *      'checkbox2' => false,       // fails if unchecked
     * ]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInFormFields()
     */
    public function cantSeeInFormFields($formSelector, array $params): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks if the array of form parameters (name => value) are not set on the form matched with
     * the passed selector.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('form[name=myform]', [
     *      'input1' => 'non-existent value',
     *      'input2' => 'other non-existent value',
     * ]);
     * ```
     *
     * To check that an element hasn't been assigned any one of many values, an array can be passed
     * as the value:
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('.form-class', [
     *      'fieldName' => [
     *          'This value shouldn\'t be set',
     *          'And this value shouldn\'t be set',
     *      ],
     * ]);
     * ```
     *
     * Additionally, checkbox values can be checked with a boolean.
     *
     * ```php
     * <?php
     * $I->dontSeeInFormFields('#form-id', [
     *      'checkbox1' => true,        // fails if checked
     *      'checkbox2' => false,       // fails if unchecked
     * ]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeInFormFields()
     */
    public function tryToDontSeeInFormFields($formSelector, array $params): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeInFormFields', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeInFormFields and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeInFormFields()
     */
    public function retryDontSeeInFormFields($formSelector, array $params) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeInFormFields', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Submits the given form on the page, with the given form
     * values.  Pass the form field's values as an array in the second
     * parameter.
     *
     * Although this function can be used as a short-hand version of
     * `fillField()`, `selectOption()`, `click()` etc. it has some important
     * differences:
     *
     *  * Only field *names* may be used, not CSS/XPath selectors nor field labels
     *  * If a field is sent to this function that does *not* exist on the page,
     *    it will silently be added to the HTTP request.  This is helpful for testing
     *    some types of forms, but be aware that you will *not* get an exception
     *    like you would if you called `fillField()` or `selectOption()` with
     *    a missing field.
     *
     * Fields that are not provided will be filled by their values from the page,
     * or from any previous calls to `fillField()`, `selectOption()` etc.
     * You don't need to click the 'Submit' button afterwards.
     * This command itself triggers the request to form's action.
     *
     * You can optionally specify which button's value to include
     * in the request with the last parameter (as an alternative to
     * explicitly setting its value in the second parameter), as
     * button values are not otherwise included in the request.
     *
     * Examples:
     *
     * ```php
     * <?php
     * $I->submitForm('#login', [
     *     'login' => 'davert',
     *     'password' => '123456'
     * ]);
     * // or
     * $I->submitForm('#login', [
     *     'login' => 'davert',
     *     'password' => '123456'
     * ], 'submitButtonName');
     *
     * ```
     *
     * For example, given this sample "Sign Up" form:
     *
     * ``` html
     * <form id="userForm">
     *     Login:
     *     <input type="text" name="user[login]" /><br/>
     *     Password:
     *     <input type="password" name="user[password]" /><br/>
     *     Do you agree to our terms?
     *     <input type="checkbox" name="user[agree]" /><br/>
     *     Subscribe to our newsletter?
     *     <input type="checkbox" name="user[newsletter]" value="1" checked="checked" /><br/>
     *     Select pricing plan:
     *     <select name="plan">
     *         <option value="1">Free</option>
     *         <option value="2" selected="selected">Paid</option>
     *     </select>
     *     <input type="submit" name="submitButton" value="Submit" />
     * </form>
     * ```
     *
     * You could write the following to submit it:
     *
     * ```php
     * <?php
     * $I->submitForm(
     *     '#userForm',
     *     [
     *         'user' => [
     *             'login' => 'Davert',
     *             'password' => '123456',
     *             'agree' => true
     *         ]
     *     ],
     *     'submitButton'
     * );
     * ```
     * Note that "2" will be the submitted value for the "plan" field, as it is
     * the selected option.
     *
     * To uncheck the pre-checked checkbox "newsletter", call `$I->uncheckOption(['name' => 'user[newsletter]']);` *before*,
     * then submit the form as shown here (i.e. without the "newsletter" field in the `$params` array).
     *
     * You can also emulate a JavaScript submission by not specifying any
     * buttons in the third parameter to submitForm.
     *
     * ```php
     * <?php
     * $I->submitForm(
     *     '#userForm',
     *     [
     *         'user' => [
     *             'login' => 'Davert',
     *             'password' => '123456',
     *             'agree' => true
     *         ]
     *     ]
     * );
     * ```
     *
     * This function works well when paired with `seeInFormFields()`
     * for quickly testing CRUD interfaces and form validation logic.
     *
     * ```php
     * <?php
     * $form = [
     *      'field1' => 'value',
     *      'field2' => 'another value',
     *      'checkbox1' => true,
     *      // ...
     * ];
     * $I->submitForm('#my-form', $form, 'submitButton');
     * // $I->amOnPage('/path/to/form-page') may be needed
     * $I->seeInFormFields('#my-form', $form);
     * ```
     *
     * Parameter values can be set to arrays for multiple input fields
     * of the same name, or multi-select combo boxes.  For checkboxes,
     * you can use either the string value or boolean `true`/`false` which will
     * be replaced by the checkbox's value in the DOM.
     *
     * ```php
     * <?php
     * $I->submitForm('#my-form', [
     *      'field1' => 'value',
     *      'checkbox' => [
     *          'value of first checkbox',
     *          'value of second checkbox',
     *      ],
     *      'otherCheckboxes' => [
     *          true,
     *          false,
     *          false
     *      ],
     *      'multiselect' => [
     *          'first option value',
     *          'second option value'
     *      ]
     * ]);
     * ```
     *
     * Mixing string and boolean values for a checkbox's value is not supported
     * and may produce unexpected results.
     *
     * Field names ending in `[]` must be passed without the trailing square
     * bracket characters, and must contain an array for its value.  This allows
     * submitting multiple values with the same name, consider:
     *
     * ```php
     * <?php
     * // This will NOT work correctly
     * $I->submitForm('#my-form', [
     *     'field[]' => 'value',
     *     'field[]' => 'another value',  // 'field[]' is already a defined key
     * ]);
     * ```
     *
     * The solution is to pass an array value:
     *
     * ```php
     * <?php
     * // This way both values are submitted
     * $I->submitForm('#my-form', [
     *     'field' => [
     *         'value',
     *         'another value',
     *     ]
     * ]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::submitForm()
     */
    public function submitForm($selector, array $params, ?string $button = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('submitForm', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Submits the given form on the page, with the given form
     * values.  Pass the form field's values as an array in the second
     * parameter.
     *
     * Although this function can be used as a short-hand version of
     * `fillField()`, `selectOption()`, `click()` etc. it has some important
     * differences:
     *
     *  * Only field *names* may be used, not CSS/XPath selectors nor field labels
     *  * If a field is sent to this function that does *not* exist on the page,
     *    it will silently be added to the HTTP request.  This is helpful for testing
     *    some types of forms, but be aware that you will *not* get an exception
     *    like you would if you called `fillField()` or `selectOption()` with
     *    a missing field.
     *
     * Fields that are not provided will be filled by their values from the page,
     * or from any previous calls to `fillField()`, `selectOption()` etc.
     * You don't need to click the 'Submit' button afterwards.
     * This command itself triggers the request to form's action.
     *
     * You can optionally specify which button's value to include
     * in the request with the last parameter (as an alternative to
     * explicitly setting its value in the second parameter), as
     * button values are not otherwise included in the request.
     *
     * Examples:
     *
     * ```php
     * <?php
     * $I->submitForm('#login', [
     *     'login' => 'davert',
     *     'password' => '123456'
     * ]);
     * // or
     * $I->submitForm('#login', [
     *     'login' => 'davert',
     *     'password' => '123456'
     * ], 'submitButtonName');
     *
     * ```
     *
     * For example, given this sample "Sign Up" form:
     *
     * ``` html
     * <form id="userForm">
     *     Login:
     *     <input type="text" name="user[login]" /><br/>
     *     Password:
     *     <input type="password" name="user[password]" /><br/>
     *     Do you agree to our terms?
     *     <input type="checkbox" name="user[agree]" /><br/>
     *     Subscribe to our newsletter?
     *     <input type="checkbox" name="user[newsletter]" value="1" checked="checked" /><br/>
     *     Select pricing plan:
     *     <select name="plan">
     *         <option value="1">Free</option>
     *         <option value="2" selected="selected">Paid</option>
     *     </select>
     *     <input type="submit" name="submitButton" value="Submit" />
     * </form>
     * ```
     *
     * You could write the following to submit it:
     *
     * ```php
     * <?php
     * $I->submitForm(
     *     '#userForm',
     *     [
     *         'user' => [
     *             'login' => 'Davert',
     *             'password' => '123456',
     *             'agree' => true
     *         ]
     *     ],
     *     'submitButton'
     * );
     * ```
     * Note that "2" will be the submitted value for the "plan" field, as it is
     * the selected option.
     *
     * To uncheck the pre-checked checkbox "newsletter", call `$I->uncheckOption(['name' => 'user[newsletter]']);` *before*,
     * then submit the form as shown here (i.e. without the "newsletter" field in the `$params` array).
     *
     * You can also emulate a JavaScript submission by not specifying any
     * buttons in the third parameter to submitForm.
     *
     * ```php
     * <?php
     * $I->submitForm(
     *     '#userForm',
     *     [
     *         'user' => [
     *             'login' => 'Davert',
     *             'password' => '123456',
     *             'agree' => true
     *         ]
     *     ]
     * );
     * ```
     *
     * This function works well when paired with `seeInFormFields()`
     * for quickly testing CRUD interfaces and form validation logic.
     *
     * ```php
     * <?php
     * $form = [
     *      'field1' => 'value',
     *      'field2' => 'another value',
     *      'checkbox1' => true,
     *      // ...
     * ];
     * $I->submitForm('#my-form', $form, 'submitButton');
     * // $I->amOnPage('/path/to/form-page') may be needed
     * $I->seeInFormFields('#my-form', $form);
     * ```
     *
     * Parameter values can be set to arrays for multiple input fields
     * of the same name, or multi-select combo boxes.  For checkboxes,
     * you can use either the string value or boolean `true`/`false` which will
     * be replaced by the checkbox's value in the DOM.
     *
     * ```php
     * <?php
     * $I->submitForm('#my-form', [
     *      'field1' => 'value',
     *      'checkbox' => [
     *          'value of first checkbox',
     *          'value of second checkbox',
     *      ],
     *      'otherCheckboxes' => [
     *          true,
     *          false,
     *          false
     *      ],
     *      'multiselect' => [
     *          'first option value',
     *          'second option value'
     *      ]
     * ]);
     * ```
     *
     * Mixing string and boolean values for a checkbox's value is not supported
     * and may produce unexpected results.
     *
     * Field names ending in `[]` must be passed without the trailing square
     * bracket characters, and must contain an array for its value.  This allows
     * submitting multiple values with the same name, consider:
     *
     * ```php
     * <?php
     * // This will NOT work correctly
     * $I->submitForm('#my-form', [
     *     'field[]' => 'value',
     *     'field[]' => 'another value',  // 'field[]' is already a defined key
     * ]);
     * ```
     *
     * The solution is to pass an array value:
     *
     * ```php
     * <?php
     * // This way both values are submitted
     * $I->submitForm('#my-form', [
     *     'field' => [
     *         'value',
     *         'another value',
     *     ]
     * ]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::submitForm()
     */
    public function tryToSubmitForm($selector, array $params, ?string $button = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('submitForm', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes submitForm and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::submitForm()
     */
    public function retrySubmitForm($selector, array $params, ?string $button = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('submitForm', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Fills a text field or textarea with the given string.
     *
     * ```php
     * <?php
     * $I->fillField("//input[@type='text']", "Hello World!");
     * $I->fillField(['name' => 'email'], 'jon@example.com');
     * ```
     * @see \Codeception\Lib\InnerBrowser::fillField()
     */
    public function fillField($field, $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('fillField', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Fills a text field or textarea with the given string.
     *
     * ```php
     * <?php
     * $I->fillField("//input[@type='text']", "Hello World!");
     * $I->fillField(['name' => 'email'], 'jon@example.com');
     * ```
     * @see \Codeception\Lib\InnerBrowser::fillField()
     */
    public function tryToFillField($field, $value): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('fillField', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes fillField and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::fillField()
     */
    public function retryFillField($field, $value) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('fillField', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Selects an option in a select tag or in radio button group.
     *
     * ```php
     * <?php
     * $I->selectOption('form select[name=account]', 'Premium');
     * $I->selectOption('form input[name=payment]', 'Monthly');
     * $I->selectOption('//form/select[@name=account]', 'Monthly');
     * ```
     *
     * Provide an array for the second argument to select multiple options:
     *
     * ```php
     * <?php
     * $I->selectOption('Which OS do you use?', ['Windows', 'Linux']);
     * ```
     *
     * Or provide an associative array for the second argument to specifically define which selection method should be used:
     *
     * ```php
     * <?php
     * $I->selectOption('Which OS do you use?', ['text' => 'Windows']); // Only search by text 'Windows'
     * $I->selectOption('Which OS do you use?', ['value' => 'windows']); // Only search by value 'windows'
     * ```
     * @see \Codeception\Lib\InnerBrowser::selectOption()
     */
    public function selectOption($select, $option): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('selectOption', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Selects an option in a select tag or in radio button group.
     *
     * ```php
     * <?php
     * $I->selectOption('form select[name=account]', 'Premium');
     * $I->selectOption('form input[name=payment]', 'Monthly');
     * $I->selectOption('//form/select[@name=account]', 'Monthly');
     * ```
     *
     * Provide an array for the second argument to select multiple options:
     *
     * ```php
     * <?php
     * $I->selectOption('Which OS do you use?', ['Windows', 'Linux']);
     * ```
     *
     * Or provide an associative array for the second argument to specifically define which selection method should be used:
     *
     * ```php
     * <?php
     * $I->selectOption('Which OS do you use?', ['text' => 'Windows']); // Only search by text 'Windows'
     * $I->selectOption('Which OS do you use?', ['value' => 'windows']); // Only search by value 'windows'
     * ```
     * @see \Codeception\Lib\InnerBrowser::selectOption()
     */
    public function tryToSelectOption($select, $option): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('selectOption', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes selectOption and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::selectOption()
     */
    public function retrySelectOption($select, $option) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('selectOption', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Ticks a checkbox. For radio buttons, use the `selectOption` method instead.
     *
     * ```php
     * <?php
     * $I->checkOption('#agree');
     * ```
     * @see \Codeception\Lib\InnerBrowser::checkOption()
     */
    public function checkOption($option): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('checkOption', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Ticks a checkbox. For radio buttons, use the `selectOption` method instead.
     *
     * ```php
     * <?php
     * $I->checkOption('#agree');
     * ```
     * @see \Codeception\Lib\InnerBrowser::checkOption()
     */
    public function tryToCheckOption($option): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('checkOption', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes checkOption and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::checkOption()
     */
    public function retryCheckOption($option) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('checkOption', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Unticks a checkbox.
     *
     * ```php
     * <?php
     * $I->uncheckOption('#notify');
     * ```
     * @see \Codeception\Lib\InnerBrowser::uncheckOption()
     */
    public function uncheckOption($option): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('uncheckOption', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Unticks a checkbox.
     *
     * ```php
     * <?php
     * $I->uncheckOption('#notify');
     * ```
     * @see \Codeception\Lib\InnerBrowser::uncheckOption()
     */
    public function tryToUncheckOption($option): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('uncheckOption', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes uncheckOption and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::uncheckOption()
     */
    public function retryUncheckOption($option) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('uncheckOption', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Attaches a file relative to the Codeception `_data` directory to the given file upload field.
     *
     * ```php
     * <?php
     * // file is stored in 'tests/_data/prices.xls'
     * $I->attachFile('input[@type="file"]', 'prices.xls');
     * ```
     * @see \Codeception\Lib\InnerBrowser::attachFile()
     */
    public function attachFile($field, string $filename): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('attachFile', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Attaches a file relative to the Codeception `_data` directory to the given file upload field.
     *
     * ```php
     * <?php
     * // file is stored in 'tests/_data/prices.xls'
     * $I->attachFile('input[@type="file"]', 'prices.xls');
     * ```
     * @see \Codeception\Lib\InnerBrowser::attachFile()
     */
    public function tryToAttachFile($field, string $filename): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('attachFile', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes attachFile and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::attachFile()
     */
    public function retryAttachFile($field, string $filename) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('attachFile', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sends an ajax GET request with the passed parameters.
     * See `sendAjaxPostRequest()`
     * @see \Codeception\Lib\InnerBrowser::sendAjaxGetRequest()
     */
    public function sendAjaxGetRequest(string $uri, array $params = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('sendAjaxGetRequest', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sends an ajax GET request with the passed parameters.
     * See `sendAjaxPostRequest()`
     * @see \Codeception\Lib\InnerBrowser::sendAjaxGetRequest()
     */
    public function tryToSendAjaxGetRequest(string $uri, array $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('sendAjaxGetRequest', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes sendAjaxGetRequest and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::sendAjaxGetRequest()
     */
    public function retrySendAjaxGetRequest(string $uri, array $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('sendAjaxGetRequest', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sends an ajax POST request with the passed parameters.
     * The appropriate HTTP header is added automatically:
     * `X-Requested-With: XMLHttpRequest`
     * Example:
     * ``` php
     * <?php
     * $I->sendAjaxPostRequest('/add-task', ['task' => 'lorem ipsum']);
     * ```
     * Some frameworks (e.g. Symfony) create field names in the form of an "array":
     * `<input type="text" name="form[task]">`
     * In this case you need to pass the fields like this:
     * ``` php
     * <?php
     * $I->sendAjaxPostRequest('/add-task', ['form' => [
     *     'task' => 'lorem ipsum',
     *     'category' => 'miscellaneous',
     * ]]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::sendAjaxPostRequest()
     */
    public function sendAjaxPostRequest(string $uri, array $params = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('sendAjaxPostRequest', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sends an ajax POST request with the passed parameters.
     * The appropriate HTTP header is added automatically:
     * `X-Requested-With: XMLHttpRequest`
     * Example:
     * ``` php
     * <?php
     * $I->sendAjaxPostRequest('/add-task', ['task' => 'lorem ipsum']);
     * ```
     * Some frameworks (e.g. Symfony) create field names in the form of an "array":
     * `<input type="text" name="form[task]">`
     * In this case you need to pass the fields like this:
     * ``` php
     * <?php
     * $I->sendAjaxPostRequest('/add-task', ['form' => [
     *     'task' => 'lorem ipsum',
     *     'category' => 'miscellaneous',
     * ]]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::sendAjaxPostRequest()
     */
    public function tryToSendAjaxPostRequest(string $uri, array $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('sendAjaxPostRequest', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes sendAjaxPostRequest and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::sendAjaxPostRequest()
     */
    public function retrySendAjaxPostRequest(string $uri, array $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('sendAjaxPostRequest', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sends an ajax request, using the passed HTTP method.
     * See `sendAjaxPostRequest()`
     * Example:
     * ``` php
     * <?php
     * $I->sendAjaxRequest('PUT', '/posts/7', ['title' => 'new title']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::sendAjaxRequest()
     */
    public function sendAjaxRequest(string $method, string $uri, array $params = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('sendAjaxRequest', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sends an ajax request, using the passed HTTP method.
     * See `sendAjaxPostRequest()`
     * Example:
     * ``` php
     * <?php
     * $I->sendAjaxRequest('PUT', '/posts/7', ['title' => 'new title']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::sendAjaxRequest()
     */
    public function tryToSendAjaxRequest(string $method, string $uri, array $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('sendAjaxRequest', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes sendAjaxRequest and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::sendAjaxRequest()
     */
    public function retrySendAjaxRequest(string $method, string $uri, array $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('sendAjaxRequest', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Use this method within an [interactive pause](https://codeception.com/docs/02-GettingStarted#Interactive-Pause) to save the HTML source code of the current page.
     *
     * ```php
     * <?php
     * $I->makeHtmlSnapshot('edit_page');
     * // saved to: tests/_output/debug/edit_page.html
     * $I->makeHtmlSnapshot();
     * // saved to: tests/_output/debug/2017-05-26_14-24-11_4b3403665fea6.html
     * ```
     * @see \Codeception\Lib\InnerBrowser::makeHtmlSnapshot()
     */
    public function makeHtmlSnapshot(?string $name = NULL): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('makeHtmlSnapshot', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Use this method within an [interactive pause](https://codeception.com/docs/02-GettingStarted#Interactive-Pause) to save the HTML source code of the current page.
     *
     * ```php
     * <?php
     * $I->makeHtmlSnapshot('edit_page');
     * // saved to: tests/_output/debug/edit_page.html
     * $I->makeHtmlSnapshot();
     * // saved to: tests/_output/debug/2017-05-26_14-24-11_4b3403665fea6.html
     * ```
     * @see \Codeception\Lib\InnerBrowser::makeHtmlSnapshot()
     */
    public function tryToMakeHtmlSnapshot(?string $name = NULL): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('makeHtmlSnapshot', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes makeHtmlSnapshot and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::makeHtmlSnapshot()
     */
    public function retryMakeHtmlSnapshot(?string $name = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('makeHtmlSnapshot', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Finds and returns the text contents of the given element.
     * If a fuzzy locator is used, the element is found using CSS, XPath,
     * and by matching the full page source by regular expression.
     *
     * ```php
     * <?php
     * $heading = $I->grabTextFrom('h1');
     * $heading = $I->grabTextFrom('descendant-or-self::h1');
     * $value = $I->grabTextFrom('~<input value=(.*?)]~sgi'); // match with a regex
     * ```
     * @see \Codeception\Lib\InnerBrowser::grabTextFrom()
     */
    public function grabTextFrom($cssOrXPathOrRegex): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabTextFrom', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabTextFrom and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabTextFrom()
     */
    public function retryGrabTextFrom($cssOrXPathOrRegex) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabTextFrom', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Returns the value of the given attribute value from the given HTML element. For some attributes, the string `true` is returned instead of their literal value (e.g. `disabled="disabled"` or `required="required"`).
     * Fails if the element is not found. Returns `null` if the attribute is not present on the element.
     *
     * ```php
     * <?php
     * $I->grabAttributeFrom('#tooltip', 'title');
     * ```
     * @see \Codeception\Lib\InnerBrowser::grabAttributeFrom()
     */
    public function grabAttributeFrom($cssOrXpath, string $attribute): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabAttributeFrom', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabAttributeFrom and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabAttributeFrom()
     */
    public function retryGrabAttributeFrom($cssOrXpath, string $attribute) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabAttributeFrom', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Grabs either the text content, or attribute values, of nodes
     * matched by $cssOrXpath and returns them as an array.
     *
     * ```html
     * <a href="#first">First</a>
     * <a href="#second">Second</a>
     * <a href="#third">Third</a>
     * ```
     *
     * ```php
     * <?php
     * // would return ['First', 'Second', 'Third']
     * $aLinkText = $I->grabMultiple('a');
     *
     * // would return ['#first', '#second', '#third']
     * $aLinks = $I->grabMultiple('a', 'href');
     * ```
     *
     * @return string[]
     * @see \Codeception\Lib\InnerBrowser::grabMultiple()
     */
    public function grabMultiple($cssOrXpath, ?string $attribute = NULL): array {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabMultiple', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabMultiple and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabMultiple()
     */
    public function retryGrabMultiple($cssOrXpath, ?string $attribute = NULL) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabMultiple', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Finds the value for the given form field.
     * If a fuzzy locator is used, the field is found by field name, CSS, and XPath.
     *
     * ```php
     * <?php
     * $name = $I->grabValueFrom('Name');
     * $name = $I->grabValueFrom('input[name=username]');
     * $name = $I->grabValueFrom('descendant-or-self::form/descendant::input[@name = 'username']');
     * $name = $I->grabValueFrom(['name' => 'username']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::grabValueFrom()
     */
    public function grabValueFrom($field): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabValueFrom', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabValueFrom and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabValueFrom()
     */
    public function retryGrabValueFrom($field) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabValueFrom', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sets a cookie with the given name and value.
     * You can set additional cookie params like `domain`, `path`, `expires`, `secure` in array passed as last argument.
     *
     * ```php
     * <?php
     * $I->setCookie('PHPSESSID', 'el4ukv0kqbvoirg7nkp4dncpk3');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::setCookie()
     */
    public function setCookie($name, $val, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('setCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sets a cookie with the given name and value.
     * You can set additional cookie params like `domain`, `path`, `expires`, `secure` in array passed as last argument.
     *
     * ```php
     * <?php
     * $I->setCookie('PHPSESSID', 'el4ukv0kqbvoirg7nkp4dncpk3');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::setCookie()
     */
    public function tryToSetCookie($name, $val, $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('setCookie', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes setCookie and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::setCookie()
     */
    public function retrySetCookie($name, $val, $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('setCookie', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Grabs a cookie value.
     * You can set additional cookie params like `domain`, `path` in array passed as last argument.
     * If the cookie is set by an ajax request (XMLHttpRequest), there might be some delay caused by the browser, so try `$I->wait(0.1)`.
     * @see \Codeception\Lib\InnerBrowser::grabCookie()
     */
    public function grabCookie(string $cookie, array $params = []): mixed {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabCookie', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabCookie and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabCookie()
     */
    public function retryGrabCookie(string $cookie, array $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabCookie', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Grabs current page source code.
     *
     * @throws \Codeception\Exception\ModuleException if no page was opened.
     * @return string Current page source code.
     * @see \Codeception\Lib\InnerBrowser::grabPageSource()
     */
    public function grabPageSource(): string {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('grabPageSource', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes grabPageSource and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::grabPageSource()
     */
    public function retryGrabPageSource() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('grabPageSource', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that a cookie with the given name is set.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * ```php
     * <?php
     * $I->seeCookie('PHPSESSID');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeCookie()
     */
    public function seeCookie($cookie, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that a cookie with the given name is set.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * ```php
     * <?php
     * $I->seeCookie('PHPSESSID');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeCookie()
     */
    public function canSeeCookie($cookie, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that a cookie with the given name is set.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * ```php
     * <?php
     * $I->seeCookie('PHPSESSID');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeCookie()
     */
    public function tryToSeeCookie($cookie, $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeCookie and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeCookie()
     */
    public function retrySeeCookie($cookie, $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeCookie', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that there isn't a cookie with the given name.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeCookie()
     */
    public function dontSeeCookie($cookie, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that there isn't a cookie with the given name.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeCookie()
     */
    public function cantSeeCookie($cookie, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that there isn't a cookie with the given name.
     * You can set additional cookie params like `domain`, `path` as array passed in last argument.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeCookie()
     */
    public function tryToDontSeeCookie($cookie, $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeCookie', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeCookie and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeCookie()
     */
    public function retryDontSeeCookie($cookie, $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeCookie', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Unsets cookie with the given name.
     * You can set additional cookie params like `domain`, `path` in array passed as last argument.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::resetCookie()
     */
    public function resetCookie($cookie, $params = []) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('resetCookie', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Unsets cookie with the given name.
     * You can set additional cookie params like `domain`, `path` in array passed as last argument.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::resetCookie()
     */
    public function tryToResetCookie($cookie, $params = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('resetCookie', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes resetCookie and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::resetCookie()
     */
    public function retryResetCookie($cookie, $params = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('resetCookie', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the given element exists on the page and is visible.
     * You can also specify expected attributes of this element.
     * Only works if `<html>` tag is present.
     *
     * ```php
     * <?php
     * $I->seeElement('.error');
     * $I->seeElement('//form/input[1]');
     * $I->seeElement('input', ['name' => 'login']);
     * $I->seeElement('input', ['value' => '123456']);
     *
     * // strict locator in first arg, attributes in second
     * $I->seeElement(['css' => 'form input'], ['name' => 'login']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeElement()
     */
    public function seeElement($selector, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeElement', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the given element exists on the page and is visible.
     * You can also specify expected attributes of this element.
     * Only works if `<html>` tag is present.
     *
     * ```php
     * <?php
     * $I->seeElement('.error');
     * $I->seeElement('//form/input[1]');
     * $I->seeElement('input', ['name' => 'login']);
     * $I->seeElement('input', ['value' => '123456']);
     *
     * // strict locator in first arg, attributes in second
     * $I->seeElement(['css' => 'form input'], ['name' => 'login']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeElement()
     */
    public function canSeeElement($selector, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeElement', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the given element exists on the page and is visible.
     * You can also specify expected attributes of this element.
     * Only works if `<html>` tag is present.
     *
     * ```php
     * <?php
     * $I->seeElement('.error');
     * $I->seeElement('//form/input[1]');
     * $I->seeElement('input', ['name' => 'login']);
     * $I->seeElement('input', ['value' => '123456']);
     *
     * // strict locator in first arg, attributes in second
     * $I->seeElement(['css' => 'form input'], ['name' => 'login']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeElement()
     */
    public function tryToSeeElement($selector, array $attributes = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeElement', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeElement and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeElement()
     */
    public function retrySeeElement($selector, array $attributes = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeElement', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the given element is invisible or not present on the page.
     * You can also specify expected attributes of this element.
     *
     * ```php
     * <?php
     * $I->dontSeeElement('.error');
     * $I->dontSeeElement('//form/input[1]');
     * $I->dontSeeElement('input', ['name' => 'login']);
     * $I->dontSeeElement('input', ['value' => '123456']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeElement()
     */
    public function dontSeeElement($selector, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeElement', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the given element is invisible or not present on the page.
     * You can also specify expected attributes of this element.
     *
     * ```php
     * <?php
     * $I->dontSeeElement('.error');
     * $I->dontSeeElement('//form/input[1]');
     * $I->dontSeeElement('input', ['name' => 'login']);
     * $I->dontSeeElement('input', ['value' => '123456']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeElement()
     */
    public function cantSeeElement($selector, array $attributes = []): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeElement', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the given element is invisible or not present on the page.
     * You can also specify expected attributes of this element.
     *
     * ```php
     * <?php
     * $I->dontSeeElement('.error');
     * $I->dontSeeElement('//form/input[1]');
     * $I->dontSeeElement('input', ['name' => 'login']);
     * $I->dontSeeElement('input', ['value' => '123456']);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeElement()
     */
    public function tryToDontSeeElement($selector, array $attributes = []): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeElement', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeElement and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeElement()
     */
    public function retryDontSeeElement($selector, array $attributes = []) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeElement', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that there are a certain number of elements matched by the given locator on the page.
     *
     * ```php
     * <?php
     * $I->seeNumberOfElements('tr', 10);
     * $I->seeNumberOfElements('tr', [0,10]); // between 0 and 10 elements
     * ```
     *
     * @param int|int[] $expected
     * @see \Codeception\Lib\InnerBrowser::seeNumberOfElements()
     */
    public function seeNumberOfElements($selector, $expected): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeNumberOfElements', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that there are a certain number of elements matched by the given locator on the page.
     *
     * ```php
     * <?php
     * $I->seeNumberOfElements('tr', 10);
     * $I->seeNumberOfElements('tr', [0,10]); // between 0 and 10 elements
     * ```
     *
     * @param int|int[] $expected
     * @see \Codeception\Lib\InnerBrowser::seeNumberOfElements()
     */
    public function canSeeNumberOfElements($selector, $expected): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeNumberOfElements', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that there are a certain number of elements matched by the given locator on the page.
     *
     * ```php
     * <?php
     * $I->seeNumberOfElements('tr', 10);
     * $I->seeNumberOfElements('tr', [0,10]); // between 0 and 10 elements
     * ```
     *
     * @param int|int[] $expected
     * @see \Codeception\Lib\InnerBrowser::seeNumberOfElements()
     */
    public function tryToSeeNumberOfElements($selector, $expected): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeNumberOfElements', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeNumberOfElements and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeNumberOfElements()
     */
    public function retrySeeNumberOfElements($selector, $expected) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeNumberOfElements', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the given option is selected.
     *
     * ```php
     * <?php
     * $I->seeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeOptionIsSelected()
     */
    public function seeOptionIsSelected($selector, $optionText) {
        return $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the given option is selected.
     *
     * ```php
     * <?php
     * $I->seeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeOptionIsSelected()
     */
    public function canSeeOptionIsSelected($selector, $optionText) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the given option is selected.
     *
     * ```php
     * <?php
     * $I->seeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeOptionIsSelected()
     */
    public function tryToSeeOptionIsSelected($selector, $optionText): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeOptionIsSelected and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeOptionIsSelected()
     */
    public function retrySeeOptionIsSelected($selector, $optionText) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeOptionIsSelected', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the given option is not selected.
     *
     * ```php
     * <?php
     * $I->dontSeeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeOptionIsSelected()
     */
    public function dontSeeOptionIsSelected($selector, $optionText) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the given option is not selected.
     *
     * ```php
     * <?php
     * $I->dontSeeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeOptionIsSelected()
     */
    public function cantSeeOptionIsSelected($selector, $optionText) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the given option is not selected.
     *
     * ```php
     * <?php
     * $I->dontSeeOptionIsSelected('#form input[name=payment]', 'Visa');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeOptionIsSelected()
     */
    public function tryToDontSeeOptionIsSelected($selector, $optionText): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeOptionIsSelected', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeOptionIsSelected and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeOptionIsSelected()
     */
    public function retryDontSeeOptionIsSelected($selector, $optionText) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeOptionIsSelected', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Asserts that current page has 404 response status code.
     * @see \Codeception\Lib\InnerBrowser::seePageNotFound()
     */
    public function seePageNotFound(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seePageNotFound', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Asserts that current page has 404 response status code.
     * @see \Codeception\Lib\InnerBrowser::seePageNotFound()
     */
    public function canSeePageNotFound(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seePageNotFound', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Asserts that current page has 404 response status code.
     * @see \Codeception\Lib\InnerBrowser::seePageNotFound()
     */
    public function tryToSeePageNotFound(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seePageNotFound', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seePageNotFound and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seePageNotFound()
     */
    public function retrySeePageNotFound() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seePageNotFound', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->seeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->seeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIs()
     */
    public function seeResponseCodeIs(int $code): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->seeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->seeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIs()
     */
    public function canSeeResponseCodeIs(int $code): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->seeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->seeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIs()
     */
    public function tryToSeeResponseCodeIs(int $code): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIs and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIs()
     */
    public function retrySeeResponseCodeIs(int $code) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIs', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that response code is between a certain range. Between actually means [from <= CODE <= to]
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsBetween()
     */
    public function seeResponseCodeIsBetween(int $from, int $to): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIsBetween', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that response code is between a certain range. Between actually means [from <= CODE <= to]
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsBetween()
     */
    public function canSeeResponseCodeIsBetween(int $from, int $to): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIsBetween', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that response code is between a certain range. Between actually means [from <= CODE <= to]
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsBetween()
     */
    public function tryToSeeResponseCodeIsBetween(int $from, int $to): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIsBetween', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIsBetween and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsBetween()
     */
    public function retrySeeResponseCodeIsBetween(int $from, int $to) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIsBetween', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->dontSeeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->dontSeeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeResponseCodeIs()
     */
    public function dontSeeResponseCodeIs(int $code): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->dontSeeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->dontSeeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeResponseCodeIs()
     */
    public function cantSeeResponseCodeIs(int $code): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that response code is equal to value provided.
     *
     * ```php
     * <?php
     * $I->dontSeeResponseCodeIs(200);
     *
     * // recommended \Codeception\Util\HttpCode
     * $I->dontSeeResponseCodeIs(\Codeception\Util\HttpCode::OK);
     * ```
     * @see \Codeception\Lib\InnerBrowser::dontSeeResponseCodeIs()
     */
    public function tryToDontSeeResponseCodeIs(int $code): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeResponseCodeIs', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeResponseCodeIs and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeResponseCodeIs()
     */
    public function retryDontSeeResponseCodeIs(int $code) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeResponseCodeIs', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the response code 2xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsSuccessful()
     */
    public function seeResponseCodeIsSuccessful(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIsSuccessful', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the response code 2xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsSuccessful()
     */
    public function canSeeResponseCodeIsSuccessful(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIsSuccessful', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the response code 2xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsSuccessful()
     */
    public function tryToSeeResponseCodeIsSuccessful(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIsSuccessful', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIsSuccessful and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsSuccessful()
     */
    public function retrySeeResponseCodeIsSuccessful() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIsSuccessful', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the response code 3xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsRedirection()
     */
    public function seeResponseCodeIsRedirection(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIsRedirection', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the response code 3xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsRedirection()
     */
    public function canSeeResponseCodeIsRedirection(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIsRedirection', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the response code 3xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsRedirection()
     */
    public function tryToSeeResponseCodeIsRedirection(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIsRedirection', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIsRedirection and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsRedirection()
     */
    public function retrySeeResponseCodeIsRedirection() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIsRedirection', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the response code is 4xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsClientError()
     */
    public function seeResponseCodeIsClientError(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIsClientError', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the response code is 4xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsClientError()
     */
    public function canSeeResponseCodeIsClientError(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIsClientError', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the response code is 4xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsClientError()
     */
    public function tryToSeeResponseCodeIsClientError(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIsClientError', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIsClientError and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsClientError()
     */
    public function retrySeeResponseCodeIsClientError() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIsClientError', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the response code is 5xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsServerError()
     */
    public function seeResponseCodeIsServerError(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeResponseCodeIsServerError', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the response code is 5xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsServerError()
     */
    public function canSeeResponseCodeIsServerError(): void {
        $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeResponseCodeIsServerError', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the response code is 5xx
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsServerError()
     */
    public function tryToSeeResponseCodeIsServerError(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeResponseCodeIsServerError', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeResponseCodeIsServerError and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeResponseCodeIsServerError()
     */
    public function retrySeeResponseCodeIsServerError() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeResponseCodeIsServerError', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the page title contains the given string.
     *
     * ```php
     * <?php
     * $I->seeInTitle('Blog - Post #1');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeInTitle()
     */
    public function seeInTitle($title) {
        return $this->getScenario()->runStep(new \Codeception\Step\Assertion('seeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the page title contains the given string.
     *
     * ```php
     * <?php
     * $I->seeInTitle('Blog - Post #1');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeInTitle()
     */
    public function canSeeInTitle($title) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('seeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the page title contains the given string.
     *
     * ```php
     * <?php
     * $I->seeInTitle('Blog - Post #1');
     * ```
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::seeInTitle()
     */
    public function tryToSeeInTitle($title): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('seeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes seeInTitle and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::seeInTitle()
     */
    public function retrySeeInTitle($title) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('seeInTitle', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Checks that the page title does not contain the given string.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeInTitle()
     */
    public function dontSeeInTitle($title) {
        return $this->getScenario()->runStep(new \Codeception\Step\Action('dontSeeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Conditional Assertion: Test won't be stopped on fail
     * Checks that the page title does not contain the given string.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeInTitle()
     */
    public function cantSeeInTitle($title) {
        return $this->getScenario()->runStep(new \Codeception\Step\ConditionalAssertion('dontSeeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Checks that the page title does not contain the given string.
     *
     * @return mixed|void
     * @see \Codeception\Lib\InnerBrowser::dontSeeInTitle()
     */
    public function tryToDontSeeInTitle($title): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('dontSeeInTitle', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes dontSeeInTitle and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::dontSeeInTitle()
     */
    public function retryDontSeeInTitle($title) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('dontSeeInTitle', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Switch to iframe or frame on the page.
     *
     * Example:
     * ``` html
     * <iframe name="another_frame" src="http://example.com">
     * ```
     *
     * ``` php
     * <?php
     * # switch to iframe
     * $I->switchToIframe("another_frame");
     * ```
     * @see \Codeception\Lib\InnerBrowser::switchToIframe()
     */
    public function switchToIframe(string $name): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('switchToIframe', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Switch to iframe or frame on the page.
     *
     * Example:
     * ``` html
     * <iframe name="another_frame" src="http://example.com">
     * ```
     *
     * ``` php
     * <?php
     * # switch to iframe
     * $I->switchToIframe("another_frame");
     * ```
     * @see \Codeception\Lib\InnerBrowser::switchToIframe()
     */
    public function tryToSwitchToIframe(string $name): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('switchToIframe', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes switchToIframe and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::switchToIframe()
     */
    public function retrySwitchToIframe(string $name) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('switchToIframe', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Moves back in history.
     *
     * @param int $numberOfSteps (default value 1)
     * @see \Codeception\Lib\InnerBrowser::moveBack()
     */
    public function moveBack(int $numberOfSteps = 1): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('moveBack', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Moves back in history.
     *
     * @param int $numberOfSteps (default value 1)
     * @see \Codeception\Lib\InnerBrowser::moveBack()
     */
    public function tryToMoveBack(int $numberOfSteps = 1): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('moveBack', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes moveBack and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::moveBack()
     */
    public function retryMoveBack(int $numberOfSteps = 1) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('moveBack', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sets SERVER parameters valid for all next requests.
     * this will remove old ones.
     *
     * ```php
     * $I->setServerParameters([]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::setServerParameters()
     */
    public function setServerParameters(array $params): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('setServerParameters', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sets SERVER parameters valid for all next requests.
     * this will remove old ones.
     *
     * ```php
     * $I->setServerParameters([]);
     * ```
     * @see \Codeception\Lib\InnerBrowser::setServerParameters()
     */
    public function tryToSetServerParameters(array $params): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('setServerParameters', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes setServerParameters and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::setServerParameters()
     */
    public function retrySetServerParameters(array $params) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('setServerParameters', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sets SERVER parameter valid for all next requests.
     *
     * ```php
     * $I->haveServerParameter('name', 'value');
     * ```
     * @see \Codeception\Lib\InnerBrowser::haveServerParameter()
     */
    public function haveServerParameter(string $name, string $value): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('haveServerParameter', func_get_args()));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Prevents automatic redirects to be followed by the client.
     *
     * ```php
     * <?php
     * $I->stopFollowingRedirects();
     * ```
     * @see \Codeception\Lib\InnerBrowser::stopFollowingRedirects()
     */
    public function stopFollowingRedirects(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('stopFollowingRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Prevents automatic redirects to be followed by the client.
     *
     * ```php
     * <?php
     * $I->stopFollowingRedirects();
     * ```
     * @see \Codeception\Lib\InnerBrowser::stopFollowingRedirects()
     */
    public function tryToStopFollowingRedirects(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('stopFollowingRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes stopFollowingRedirects and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::stopFollowingRedirects()
     */
    public function retryStopFollowingRedirects() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('stopFollowingRedirects', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Enables automatic redirects to be followed by the client.
     *
     * ```php
     * <?php
     * $I->startFollowingRedirects();
     * ```
     * @see \Codeception\Lib\InnerBrowser::startFollowingRedirects()
     */
    public function startFollowingRedirects(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('startFollowingRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Enables automatic redirects to be followed by the client.
     *
     * ```php
     * <?php
     * $I->startFollowingRedirects();
     * ```
     * @see \Codeception\Lib\InnerBrowser::startFollowingRedirects()
     */
    public function tryToStartFollowingRedirects(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('startFollowingRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes startFollowingRedirects and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::startFollowingRedirects()
     */
    public function retryStartFollowingRedirects() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('startFollowingRedirects', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Follow pending redirect if there is one.
     *
     * ```php
     * <?php
     * $I->followRedirect();
     * ```
     * @see \Codeception\Lib\InnerBrowser::followRedirect()
     */
    public function followRedirect(): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('followRedirect', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Follow pending redirect if there is one.
     *
     * ```php
     * <?php
     * $I->followRedirect();
     * ```
     * @see \Codeception\Lib\InnerBrowser::followRedirect()
     */
    public function tryToFollowRedirect(): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('followRedirect', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes followRedirect and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::followRedirect()
     */
    public function retryFollowRedirect() {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('followRedirect', func_get_args(), $retryNum, $retryInterval));
    }

 
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * Sets the maximum number of redirects that the Client can follow.
     *
     * ```php
     * <?php
     * $I->setMaxRedirects(2);
     * ```
     * @see \Codeception\Lib\InnerBrowser::setMaxRedirects()
     */
    public function setMaxRedirects(int $maxRedirects): void {
        $this->getScenario()->runStep(new \Codeception\Step\Action('setMaxRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated. Documentation taken from corresponding module.
     *
     * [!] Test won't be stopped on fail. Error won't be logged 
     * Sets the maximum number of redirects that the Client can follow.
     *
     * ```php
     * <?php
     * $I->setMaxRedirects(2);
     * ```
     * @see \Codeception\Lib\InnerBrowser::setMaxRedirects()
     */
    public function tryToSetMaxRedirects(int $maxRedirects): bool {
        return $this->getScenario()->runStep(new \Codeception\Step\TryTo('setMaxRedirects', func_get_args()));
    }
    /**
     * [!] Method is generated.
     *
     * * Executes setMaxRedirects and retries on failure.
     *
     * Retry number and interval set by $I->retry();
     *
     * @see \Codeception\Lib\InnerBrowser::setMaxRedirects()
     */
    public function retrySetMaxRedirects(int $maxRedirects) {
        $retryNum      = $this->retryNum ?? 1;
        $retryInterval = $this->retryInterval ?? 200;
        return $this->getScenario()->runStep(new \Codeception\Step\Retry('setMaxRedirects', func_get_args(), $retryNum, $retryInterval));
    }
}
