<?php

declare(strict_types=1);

namespace Infrastructure\Http;

use HttpMethod;
use utils\NotFoundException;

final class Router
{
    /**
     * @param array<string, array{0: object, 1: string}> $routes
     */
    public function __construct(
        private array $routes
    ) {}

    public function dispatch(HttpMethod $method, string $path): void
    {
        $key = $method->name . ' ' . $path;

        if (!isset($this->routes[$key])) {
            throw new NotFoundException();
        }

        [$controller, $action] = $this->routes[$key];

        $controller->$action();
    }
}

