<?php

declare(strict_types=1);

namespace Domain\Repositories;

use Domain\Entities\User;

interface UserRepositoryInterface
{
    /**
     * ユーザー名で検索します
     *
     * @return User|null
     */
    public function findByUsername(string $username): ?User;

    /**
     * ユーザーを永続化（新規作成）
     *
     * 挿入後 User を返します
     *
     * @return User 保存後のユーザーエンティティ
     */
    public function save(User $user): User;
}
