<?php

declare(strict_types=1);

namespace Application\UseCases\User;

/**
 * ユーザー登録ユースケースの出力データ
 * Controller はこれをもとに ViewModel やレスポンスを組み立てる。
 */
final class UserRegisterOutput
{
    public function __construct(
        private string $username
    ) {}

    public function username(): string
    {
        return $this->username;
    }
}
