<?php

declare(strict_types=1);

namespace Application\UseCases\User;

/**
 * ユーザー登録ユースケースの入力データ
 * （Controller や CLI などの外側の層から渡される）
 */
final class UserRegisterInput
{
    public function __construct(
        private string $username,
        private string $email,
        private string $plainPassword
    ) {}

    public function username(): string
    {
        return $this->username;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function plainPassword(): string
    {
        return $this->plainPassword;
    }
}
