<?php

namespace routes;

use HttpMethod;
use Infrastructure\Http\Router;

function users(HttpMethod $method, string $rpath, Router $router): bool
{
    switch (true) {
        case $rpath === 'register':
            switch ($method) {
                case HttpMethod::GET:
                    \view\users\register\index();
                    break;

                case HttpMethod::POST:
                    // \controller\users\register();
                    $router->dispatch($method, $rpath);
                    break;
            }
            break;

        case $rpath === 'login':
            switch ($method) {
                case HttpMethod::GET:
                    \view\users\login\index();
                    break;

                case HttpMethod::POST:
                    \controller\users\login('おかえりなさい！！');
                    break;
            }
            break;

        case $rpath === 'logout':
            \controller\users\logout();
            break;

        default:
            return false;
    }

    return true;
}
