<?php

namespace routes;

use HttpMethod;

function reviews(HttpMethod $method, string $rpath): bool
{
    switch (true) {
        case preg_match('/campgrounds\/([0-9]+)\/reviews\/([0-9]+)/i', $rpath, $match):
            $id = (int)$match[1];
            $review_id = (int)$match[2];
            \controller\campground\review\deleteReview($id, $review_id);
            break;

        case preg_match('/campgrounds\/([0-9]+)\/reviews/i', $rpath, $match):
            $id = (int)$match[1];
            \controller\campground\review\createReview($id);
            break;

        default:
            return false;
    }

    return true;
}
