<?php

namespace models;

use InvalidArgumentException;
use utils\YelpCampError;

class ReviewSchema
{
    public int $id;
    public string $body;
    public int $rating;
    public int $camp_id;
    public string $author; // = users.username

    /**
     * @param object $obj
     */
    public static function cast(object $obj): self
    {
        if (!($obj instanceof self)) {
            $name = get_class($obj);
            throw new InvalidArgumentException("{$name} は ReviewSchema ではありません。");
        }
        return $obj;
    }

    public static function getModel(): self
    {
        $params = get_asoc_params('review', '');
        $body = get_item($params, 'body');
        $rating = get_item($params, 'rating');

        if (empty($body)) throw new YelpCampError('コメントがありません。');
        if (empty($rating)) throw new YelpCampError('評価がありません。');
        if (!is_numeric($rating)) throw new YelpCampError('評価が数値ではありません。');
        $rating_value = intval($rating);
        if ($rating_value < 1 || 5 < $rating_value) throw new YelpCampError('評価が範囲外です。');

        $review = new ReviewSchema;
        $review->body = $body;
        $review->rating = $rating_value;

        return $review;
    }

    public function isOwner(UserSchema|null $user): bool
    {
        return !empty($user) && $user->username === $this->author;
    }
}
