DROP DATABASE IF EXISTS `YelpCampCleanArch`;

CREATE DATABASE `YelpCampCleanArch`;

use `YelpCampCleanArch`;

-- YelpCampCleanArch.campgrounds definition
CREATE TABLE
    `campgrounds` (
        `id` int (10) unsigned NOT NULL AUTO_INCREMENT,
        `title` varchar(100) DEFAULT NULL,
        `price` int (11) DEFAULT NULL,
        `description` varchar(1000) DEFAULT NULL,
        `location` varchar(100) DEFAULT NULL,
        `author` varchar(100) NOT NULL,
        `geometry` varchar(200) DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `campgrounds_users_FK` (`author`)
    ) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- YelpCampCleanArch.reviews definition
CREATE TABLE
    `reviews` (
        `id` int (10) unsigned NOT NULL AUTO_INCREMENT,
        `body` longtext DEFAULT NULL,
        `rating` int (11) DEFAULT NULL,
        `camp_id` int (10) unsigned DEFAULT NULL,
        `author` varchar(100) NOT NULL,
        PRIMARY KEY (`id`),
        KEY `reviews_campgrounds_FK` (`camp_id`),
        KEY `reviews_users_FK` (`author`)
    ) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- YelpCampCleanArch.users definition
CREATE TABLE
    `users` (
        `username` varchar(100) NOT NULL,
        `email` varchar(100) NOT NULL,
        `password` varchar(100) NOT NULL,
        PRIMARY KEY (`username`)
    ) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- YelpCampCleanArch.images definition
CREATE TABLE
    `images` (
        `id` int (10) unsigned NOT NULL AUTO_INCREMENT,
        `filename` varchar(200) DEFAULT NULL,
        `camp_id` int (10) unsigned NOT NULL,
        `thumbnail` varchar(200) DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `images_images_FK` (`camp_id`)
    ) ENGINE = InnoDB AUTO_INCREMENT = 1 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_general_ci;
