<?php

namespace controller\campground\review;

use db\ReviewQuery;
use db\CampGroundQuery;
use models\ReviewSchema;
use utils\Flush;
use utils\NotFoundException;

use function middleware\currentUser;

function createReview(int $id): void
{
    $user = \middleware\isLoggedIn("/campgrounds/{$id}");

    if (is_null($user)) return;

    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();
    $review = ReviewSchema::getModel();
    $review->camp_id = $id;
    $review->author = $user->username;
    $review =  ReviewQuery::insert($review);
    Flush::push(Flush::INFO, 'レビューを投稿しました');
    redirect("/campgrounds/{$id}");
}

function deleteReview(int $id, int $review_id): void
{
    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();

    $review = ReviewQuery::findById($review_id);
    if (empty($review)) throw new NotFoundException();

    \middleware\isReviewAuthor($campground, $review, currentUser());

    ReviewQuery::findByIdAndDelete($review_id);
    Flush::push(Flush::INFO, 'レビューを削除しました');
    redirect("/campgrounds/{$id}");
}
