<?php

namespace controller\campground;

use utils\Flush;
use db\CampGroundQuery;
use utils\NotFoundException;
use models\CampGroundSchema;
use utils\YelpCampError;

use function middleware\currentUser;

function createCampground(): void
{
    $user = \middleware\isLoggedIn('/campgrounds/');

    $campground = CampGroundSchema::getModel();
    $campground->geometry = forwardGeocode($campground->location);
    $campground->author = is_null($user) ? '' : $user->username;
    $campground =  CampGroundQuery::save($campground);
    if (empty($campground)) {
        Flush::push(Flush::ERROR, 'キャンプ場が登録できませんでした');
        redirect("/campgrounds");
        return;
    }
    $id = $campground->id;
    Flush::push(Flush::INFO, '登録しました');
    redirect("/campgrounds/{$id}");
}

function updateCampground(int $id): void
{
    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();
    $user = currentUser();
    \middleware\isAuthor($campground, $user);

    $images = $campground->images ?? [];
    try {
        $campground = CampGroundSchema::getModel();
    } catch (YelpCampError $e) {
        Flush::push(Flush::ERROR, $e->getMessage());
        redirect("/campgrounds/{$id}/edit");
        return;
    }
    $campground->geometry = forwardGeocode($campground->location);
    $campground->author = is_null($user) ? '' : $user->username;
    $campground->id = $id;
    if (!empty($campground->images)) {
        array_map(fn($a) => $a->camp_id = $id, $campground->images);
        array_push($images, ...$campground->images);
    }
    $campground->images = $images;
    $campground =  CampGroundQuery::update($campground);
    if (empty($campground)){
        Flush::push(Flush::ERROR, 'キャンプ場が更新できませんでした');
        redirect("/campgrounds/{$id}/edit");
        return;
    }
    Flush::push(Flush::INFO, 'キャンプ場を更新しました');
    redirect("/campgrounds/{$id}");
}

function deleteCampground(int $id): void
{
    $campground = CampGroundQuery::findById($id);
    if (empty($campground)) throw new NotFoundException();
    \middleware\isAuthor($campground, currentUser());
    CampGroundQuery::findByIdAndDelete($id);
    redirect("/campgrounds");
}
