<?php
define('CURRENT_URI', $_SERVER['REQUEST_URI']);
if (is_string(CURRENT_URI) && preg_match("/(.+(yelpcampcleanarch))/i", CURRENT_URI, $match)) {
    define('BASE_CONTEXT_PATH', $match[0] . '/');
} else {
    define('BASE_CONTEXT_PATH', '/');
}
define('BASE_IMAGE_PATH', BASE_CONTEXT_PATH . 'images/');
define('BASE_JS_PATH', BASE_CONTEXT_PATH . 'public/javascripts/');
define('BASE_CSS_PATH', BASE_CONTEXT_PATH . 'public/stylesheets/');

define('GO_HOME', 'home');
define('GO_REFERER', 'referer');

/**
 * 動作環境に合わせて以下の定数を設定してください
 */
// trueにするとデバッグ情報を表示します
define('DEBUG', true);
// MySQLの待ち受けポート
define('MYSQL_PORT', '3306');
// Windows版のPHPを使用する場合はtrueにします (サムネイル作成とMapbox通信方法が切り替わります)
define('IS_WINDOWS', strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');
// Mapboxのパブリックトークンを設定します (地図を表示する場合は設定してください)
define('MAPBOX_TOKEN', '');

return [
    'db' => [
        'driver' => 'pdo',
        'dsn'  => 'mysql:host=localhost;port=' . MYSQL_PORT . ';dbname=YelpCampCleanArch;charset=utf8mb4',
        'user' => 'clean_arch',
        'pass' => 'password',
    ],
];